/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cades.criteria;

import de.governikus.csl.cades.CMSSignature;
import de.governikus.csl.cades.SignerInfoIssue;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.uom.validate.commons.Timestamp;
import de.governikus.csl.validate.svp.CAdESSignatureValidationResult;
import de.governikus.csl.validate.svp.TimestampValidationResult;
import de.governikus.csl.validate.svp.ValidationMessageCode;
import de.governikus.csl.validate.svp.ValidationResult;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.criteria.RecursiveValidationCriterion;
import java.util.ArrayList;
import java.util.List;

public class CheckSignerInfoIssues
extends RecursiveValidationCriterion<CMSSignature, CAdESSignatureValidationResult, Timestamp, TimestampValidationResult, SignatureValidationContext> {
    public void verify(CMSSignature signature, CAdESSignatureValidationResult result, SignatureValidationContext context) {
        ValidationResult signerInfoValidationResult;
        boolean isTotalFailed = false;
        ArrayList<ValidationMessageCode> messageCodeList = new ArrayList<ValidationMessageCode>();
        List<SignerInfoIssue> issueList = signature.getSignerInfoIssueList();
        for (SignerInfoIssue issue : issueList) {
            switch (issue) {
                case MISSING_SIGNATURE_ALGORITHM_OID: {
                    isTotalFailed = true;
                    messageCodeList.add(SVPFactory.createMessageCode((String)"cades_signer_info_missing_algorithm_oid"));
                    break;
                }
                case UNKNOWN_SIGNATURE_ALGORITHM: {
                    if (signature.getSignatureAlgorithmName() == null || signature.getSignatureAlgorithmOID() == null) {
                        messageCodeList.add(SVPFactory.createMessageCode((String)"cades_signer_info_unknown_algorithm_general"));
                        break;
                    }
                    messageCodeList.add(SVPFactory.createMessageCode((String)"cades_signer_info_unknown_algorithm"));
                    break;
                }
                case PARSE_ERROR: {
                    isTotalFailed = true;
                    messageCodeList.add(SVPFactory.createMessageCode((String)"cades_signer_info_parse_error"));
                    break;
                }
                case MISSING_CONTENT: {
                    messageCodeList.add(SVPFactory.createMessageCode((String)"cades_signer_info_missing_content"));
                    break;
                }
                case NO_MATCHING_SIGNING_CERTIFICATE: {
                    messageCodeList.add(SVPFactory.createMessageCode((String)"cades_signer_info_no_matching_signing_certificate"));
                    break;
                }
                case CANNOT_RECREATE_SIGNING_CERTIFICATE: {
                    messageCodeList.add(SVPFactory.createMessageCode((String)"cades_signer_info_cannot_recreate_signing_certificate"));
                    break;
                }
            }
        }
        if (!messageCodeList.isEmpty()) {
            signerInfoValidationResult = SVPFactory.create((MajorTotalResult)(isTotalFailed ? MajorTotalResult.TOTAL_FAILED : MajorTotalResult.INDETERMINATE), (MinorResult)MinorResult.FORMAT_FAILURE);
            signerInfoValidationResult.getMessages().addAll(messageCodeList);
        } else {
            signerInfoValidationResult = SVPFactory.createResultOk();
        }
        result.setSignerInfoValidationResult(signerInfoValidationResult);
    }
}

