/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cades.criteria;

import de.governikus.csl.cades.CMSSignature;
import de.governikus.csl.core.impl.CumulatedValidationResultImpl;
import de.governikus.csl.uom.Plugin;
import de.governikus.csl.uom.validate.commons.ResultAggregator;
import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.uom.validate.commons.Timestamp;
import de.governikus.csl.utils.SignalAggregateUtil;
import de.governikus.csl.validate.svp.CAdESSignatureValidationResult;
import de.governikus.csl.validate.svp.TimestampValidationResult;
import de.governikus.csl.validation.AbstractDocumentPlugin;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.criteria.RecursiveValidationCriterion;
import de.governikus.csl.validation.tsp.TSPPlugin;
import de.governikus.csl.validation.tsp.TimestampedObject;
import java.util.List;

public class CheckCertCRLTimestamps
extends RecursiveValidationCriterion<CMSSignature, CAdESSignatureValidationResult, Timestamp, TimestampValidationResult, SignatureValidationContext> {
    public void verify(CMSSignature signature, CAdESSignatureValidationResult result, SignatureValidationContext context) {
        List<TimestampedObject> timestamps = signature.getCertCRLTimestamps();
        if (timestamps != null) {
            CumulatedValidationResultImpl vr = new CumulatedValidationResultImpl();
            TSPPlugin plugin = (TSPPlugin)context.getConfiguration().getPlugin(Plugin.PluginID.VALIDATE_TSP.getID());
            List results = result.getCertCRLTimestampValidationResult();
            for (TimestampedObject tsp : timestamps) {
                SignatureValidationContext tsContext = plugin.createContext((Signature)tsp, context);
                tsContext.setCertificatePathReferences(null);
                TimestampValidationResult valResult = (TimestampValidationResult)this.recursiveCall((Signature)tsp, (AbstractDocumentPlugin)plugin, tsContext);
                SignalAggregateUtil.aggregateCumulated((boolean)true, (ResultAggregator[])new ResultAggregator[]{vr, valResult});
                results.add(valResult);
            }
        }
    }
}

