/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cades.attributes;

import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.cms.SignedAttribute;
import de.governikus.csl.cades.attributes.AttributeProcessor;
import de.governikus.csl.validate.svp.AttributeBaseType;
import de.governikus.csl.validate.svp.ObjectFactory;
import de.governikus.csl.validate.svp.TimeAttributeType;
import java.io.IOException;
import javax.xml.bind.JAXBElement;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SigningTimeProcessor
implements AttributeProcessor {
    private static final Logger logger = LoggerFactory.getLogger(SigningTimeProcessor.class);
    private final ObjectFactory svpFactory;
    private AttributeProcessor next;

    public SigningTimeProcessor(ObjectFactory svpFactory) {
        this.svpFactory = svpFactory;
    }

    @Override
    public AttributeProcessor append(AttributeProcessor next) {
        this.next = next;
        return next;
    }

    @Override
    public JAXBElement<? extends AttributeBaseType> process(ANY attribute) {
        SignedAttribute sAttr;
        JAXBElement result = null;
        if (attribute instanceof SignedAttribute && (sAttr = (SignedAttribute)attribute).getOID().equals(CMSAttributes.signingTime.getId())) {
            TimeAttributeType timeAttribute = this.svpFactory.createTimeAttributeType();
            timeAttribute.setSigned(Boolean.TRUE);
            byte[] timeObject = ((ANY)sAttr.getValues().get(0)).getEncoded();
            try {
                Time time = Time.getInstance((Object)ASN1Primitive.fromByteArray((byte[])timeObject));
                timeAttribute.setTime(time.getDate());
                result = this.svpFactory.createSignatureAttributesTypeSigningTime(timeAttribute);
            }
            catch (IOException e) {
                logger.warn("SigningTime attribute has a wrong encoding and is therefore ignored.");
            }
        }
        if (result == null && this.next != null) {
            result = this.next.process(attribute);
        }
        return result;
    }
}

