/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cades.attributes;

import de.bos_bremen.algorithm_identifier.AlgorithmService;
import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.cms.SignedAttribute;
import de.governikus.csl.cades.attributes.AttributeProcessor;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.validate.svp.AttributeBaseType;
import de.governikus.csl.validate.svp.CertIDListType;
import de.governikus.csl.validate.svp.CertIDType;
import de.governikus.csl.validate.svp.ObjectFactory;
import java.io.IOException;
import javax.xml.bind.JAXBElement;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ess.ESSCertID;
import org.bouncycastle.asn1.ess.SigningCertificate;

public class SigningCertificateV1Processor
implements AttributeProcessor {
    private static final ASN1ObjectIdentifier SIGNING_CERT_V1_OID = new ASN1ObjectIdentifier("1.2.840.113549.1.9.16.2.12");
    private final ObjectFactory svpFactory;
    private AttributeProcessor next;

    public SigningCertificateV1Processor(ObjectFactory svpFactory) {
        this.svpFactory = svpFactory;
    }

    @Override
    public AttributeProcessor append(AttributeProcessor next) {
        this.next = next;
        return next;
    }

    @Override
    public JAXBElement<? extends AttributeBaseType> process(ANY attribute) {
        SignedAttribute sAttr;
        JAXBElement result = null;
        if (attribute instanceof SignedAttribute && (sAttr = (SignedAttribute)attribute).getOID().equals(SIGNING_CERT_V1_OID.getId())) {
            byte[] attrValue = ((ANY)sAttr.getValues().get(0)).asByteArray();
            SigningCertificate signingCert = SigningCertificate.getInstance((Object)attrValue);
            ESSCertID[] certs = signingCert.getCerts();
            CertIDListType certList = this.svpFactory.createCertIDListType();
            certList.setSigned(Boolean.valueOf(true));
            for (ESSCertID cert : certs) {
                CertIDType certId = this.svpFactory.createCertIDType();
                DigestAlgorithm sha1 = AlgorithmService.getDigestForOID((String)"1.3.14.3.2.26");
                de.governikus.csl.validate.svp.DigestAlgorithm digestAlgo = SVPFactory.createDigestAlgorithm((DigestAlgorithm)sha1);
                this.setCertIdInfo(cert, certId, digestAlgo);
                certList.getCertID().add(certId);
            }
            result = this.svpFactory.createSignatureAttributesTypeSigningCertificate(certList);
        }
        if (result == null && this.next != null) {
            result = this.next.process(attribute);
        }
        return result;
    }

    private void setCertIdInfo(ESSCertID cert, CertIDType certId, de.governikus.csl.validate.svp.DigestAlgorithm digestAlgo) {
        certId.setDigestMethod(digestAlgo);
        certId.setDigestValue(cert.getCertHash());
        if (cert.getIssuerSerial() != null) {
            try {
                certId.setX509IssuerSerial(cert.getIssuerSerial().getEncoded());
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

