/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cades.attributes;

import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.cms.SignedAttribute;
import de.governikus.csl.cades.attributes.AttributeProcessor;
import de.governikus.csl.validate.svp.AttributeBaseType;
import de.governikus.csl.validate.svp.ObjectFactory;
import de.governikus.csl.validate.svp.SignerLocationType;
import javax.xml.bind.JAXBElement;
import org.bouncycastle.asn1.esf.SignerLocation;
import org.bouncycastle.asn1.x500.DirectoryString;

public class SignerLocationProcessor
implements AttributeProcessor {
    private final ObjectFactory svpFactory;
    private AttributeProcessor next;

    public SignerLocationProcessor(ObjectFactory svpFactory) {
        this.svpFactory = svpFactory;
    }

    @Override
    public AttributeProcessor append(AttributeProcessor next) {
        this.next = next;
        return next;
    }

    @Override
    public JAXBElement<? extends AttributeBaseType> process(ANY attribute) {
        SignedAttribute sAttr;
        JAXBElement result = null;
        if (attribute instanceof SignedAttribute && (sAttr = (SignedAttribute)attribute).getOID().equals(SignedAttribute.SIGNER_LOCATION.getOID())) {
            SignerLocation signerLocation = SignerLocation.getInstance((Object)((ANY)sAttr.getValues().get(0)).getEncoded());
            SignerLocationType signerLocationTypeObj = this.svpFactory.createSignerLocationType();
            signerLocationTypeObj.setSigned(Boolean.TRUE);
            if (signerLocation.getCountry() != null) {
                signerLocationTypeObj.setCountryName(signerLocation.getCountry().getString());
            }
            if (signerLocation.getLocality() != null) {
                signerLocationTypeObj.setLocalityName(signerLocation.getLocality().getString());
            }
            if (signerLocation.getPostal() != null) {
                for (DirectoryString dirString : signerLocation.getPostal()) {
                    signerLocationTypeObj.getAddress().add(dirString.getString());
                }
            }
            result = this.svpFactory.createSignatureAttributesTypeSignerLocation(signerLocationTypeObj);
        }
        if (result == null && this.next != null) {
            result = this.next.process(attribute);
        }
        return result;
    }
}

