/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cades.attributes;

import de.bos_bremen.ci.BSource;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.Source;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.cms.CertifiedAttributesV2;
import de.bos_bremen.ci.asn1.cms.ClaimedAttributes;
import de.bos_bremen.ci.asn1.cms.SignedAttribute;
import de.bos_bremen.ci.asn1.cms.SignerAttributeV2;
import de.bos_bremen.ci.asn1.x509.Attribute;
import de.governikus.csl.cades.attributes.AttributeProcessor;
import de.governikus.csl.validate.svp.AttributeBaseType;
import de.governikus.csl.validate.svp.ObjectFactory;
import de.governikus.csl.validate.svp.RoleDetailsType;
import de.governikus.csl.validate.svp.SignerRoleType;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignerAttributeV2Processor
implements AttributeProcessor {
    public static final String OID_SIGNER_ATTRIBUTE_V2 = "0.4.0.19122.1.1";
    private static final Logger LOG = LoggerFactory.getLogger(SignerAttributeV2Processor.class);
    private final ObjectFactory svpFactory;
    private AttributeProcessor next;

    public SignerAttributeV2Processor(ObjectFactory svpFactory) {
        this.svpFactory = svpFactory;
    }

    @Override
    public AttributeProcessor append(AttributeProcessor next) {
        this.next = next;
        return next;
    }

    @Override
    public JAXBElement<? extends AttributeBaseType> process(ANY attribute) {
        SignedAttribute signedAttribute;
        JAXBElement result = null;
        if (attribute instanceof SignedAttribute && (signedAttribute = (SignedAttribute)attribute).getOID().equals(OID_SIGNER_ATTRIBUTE_V2)) {
            SignerAttributeV2 signerAttributeV2 = this.asSignerAttributeV2(signedAttribute);
            if (signerAttributeV2 == null) {
                return null;
            }
            SignerRoleType signerRoleType = this.svpFactory.createSignerRoleType();
            signerRoleType.setSigned(Boolean.valueOf(true));
            this.processClaimedAttributes(signerRoleType, signerAttributeV2.getClaimedAttributes());
            this.processCertifiedAttributes(signerRoleType, signerAttributeV2.getCertifiedAttributes());
            result = this.svpFactory.createSignatureAttributesTypeSignerRole(signerRoleType);
        }
        if (result == null && this.next != null) {
            result = this.next.process(attribute);
        }
        return result;
    }

    private void processClaimedAttributes(SignerRoleType signerRoleType, List<ClaimedAttributes> claimedAttributes) {
        for (ClaimedAttributes claimedAttribute : claimedAttributes) {
            for (Attribute attribute : claimedAttribute.getAttributes()) {
                this.processAttribute(signerRoleType, attribute, "claimed");
            }
        }
    }

    private void processCertifiedAttributes(SignerRoleType signerRoleType, List<CertifiedAttributesV2> certifiedAttributes) {
        for (CertifiedAttributesV2 certifiedAttribute : certifiedAttributes) {
            for (Attribute attribute : certifiedAttribute.getAttributeCertificate().getAttributeCertificateInfo().getAttributes()) {
                this.processAttribute(signerRoleType, attribute, "certified");
            }
        }
    }

    private void processAttribute(SignerRoleType signerRoleType, Attribute attribute, String endorsement) {
        for (ANY value : attribute.getValues()) {
            RoleDetailsType roleDetailsType = this.svpFactory.createRoleDetailsType();
            roleDetailsType.setEndorsement(endorsement);
            roleDetailsType.setRole(value.getValueAsString());
            signerRoleType.getRoleDetails().add(roleDetailsType);
        }
    }

    private SignerAttributeV2 asSignerAttributeV2(SignedAttribute signedAttribute) {
        try {
            return new SignerAttributeV2(Run.create((Source)new BSource(((ANY)signedAttribute.getValues().get(0)).asByteArray())));
        }
        catch (ParseException e) {
            LOG.error("Could not parse signed attribute value", (Throwable)e);
            return null;
        }
    }
}

