/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cades.attributes;

import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.cms.SignedAttribute;
import de.governikus.csl.cades.attributes.AttributeProcessor;
import de.governikus.csl.validate.svp.AttributeBaseType;
import de.governikus.csl.validate.svp.ObjectFactory;
import de.governikus.csl.validate.svp.SigPolicyIdentifierType;
import javax.xml.bind.JAXBElement;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.esf.SignaturePolicyId;

public class SignaturePolicyIdentifierProcessor
implements AttributeProcessor {
    private static final ASN1ObjectIdentifier SIG_POLICY_ID_OID = new ASN1ObjectIdentifier("1.2.840.113549.1.9.16.2.15");
    private final ObjectFactory svpFactory;
    private AttributeProcessor next;

    public SignaturePolicyIdentifierProcessor(ObjectFactory svpFactory) {
        this.svpFactory = svpFactory;
    }

    @Override
    public AttributeProcessor append(AttributeProcessor next) {
        this.next = next;
        return next;
    }

    @Override
    public JAXBElement<? extends AttributeBaseType> process(ANY attribute) {
        SignedAttribute sAttr;
        JAXBElement result = null;
        if (attribute instanceof SignedAttribute && (sAttr = (SignedAttribute)attribute).getOID().equals(SIG_POLICY_ID_OID.getId())) {
            SigPolicyIdentifierType sigPolicyIdType = this.svpFactory.createSigPolicyIdentifierType();
            sigPolicyIdType.setSigned(Boolean.TRUE);
            byte[] sigPolicyIdBytes = ((ANY)sAttr.getValues().get(0)).getEncoded();
            SignaturePolicyId sigPolicyId = SignaturePolicyId.getInstance((Object)sigPolicyIdBytes);
            sigPolicyIdType.setSigPolicyId(sigPolicyId.getSigPolicyId().getId());
            result = this.svpFactory.createSignatureAttributesTypeSignaturePolicyIdentifier(sigPolicyIdType);
        }
        if (result == null && this.next != null) {
            result = this.next.process(attribute);
        }
        return result;
    }
}

