/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cades.attributes;

import de.bos_bremen.ci.BSource;
import de.bos_bremen.ci.Source;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.OBJECTIDENTIFIER;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.cms.CMSSignedData;
import de.bos_bremen.ci.asn1.cms.SignedAttribute;
import de.bos_bremen.ci.asn1.cms.SignedAttributes;
import de.bos_bremen.ci.asn1.cms.SignedData;
import de.bos_bremen.ci.asn1.cms.SignerInfo;
import de.governikus.csl.cades.attributes.ArchiveTimeStampV2Processor;
import de.governikus.csl.cades.attributes.ArchiveTimeStampV3Processor;
import de.governikus.csl.cades.attributes.AttributeCertificateRefsProcessor;
import de.governikus.csl.cades.attributes.AttributeProcessor;
import de.governikus.csl.cades.attributes.AttributeRevocationRefsProcessor;
import de.governikus.csl.cades.attributes.CAdESCTimestampProcessor;
import de.governikus.csl.cades.attributes.CMSAlgorithmProtectionProcessor;
import de.governikus.csl.cades.attributes.CertificateValuesProcessor;
import de.governikus.csl.cades.attributes.CommitmentTypeIndicationProcessor;
import de.governikus.csl.cades.attributes.CompleteCertificateRefsProcessor;
import de.governikus.csl.cades.attributes.CompleteRevocationRefsProcessor;
import de.governikus.csl.cades.attributes.ContentTimestampProcessor;
import de.governikus.csl.cades.attributes.ContentTypeProcessor;
import de.governikus.csl.cades.attributes.CounterSignatureProcessor;
import de.governikus.csl.cades.attributes.LongTermValidationProcessor;
import de.governikus.csl.cades.attributes.MessageDigestProcessor;
import de.governikus.csl.cades.attributes.MimeTypeProcessor;
import de.governikus.csl.cades.attributes.RevocationValuesProcessor;
import de.governikus.csl.cades.attributes.SignaturePolicyIdentifierProcessor;
import de.governikus.csl.cades.attributes.SignatureTimestampProcessor;
import de.governikus.csl.cades.attributes.SignerAttributeV2Processor;
import de.governikus.csl.cades.attributes.SignerLocationProcessor;
import de.governikus.csl.cades.attributes.SigningCertificateV1Processor;
import de.governikus.csl.cades.attributes.SigningCertificateV2Processor;
import de.governikus.csl.cades.attributes.SigningTimeProcessor;
import de.governikus.csl.cades.attributes.TimestampedCertsCrlsReferencesProcessor;
import de.governikus.csl.validate.svp.AttributeBaseType;
import de.governikus.csl.validate.svp.ObjectFactory;
import de.governikus.csl.validate.svp.SignatureAttributesType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.xml.bind.JAXBElement;

public class SignatureAttributesGenerator {
    private static final ObjectFactory svpFactory = new ObjectFactory();
    private static AttributeProcessor processor = new MessageDigestProcessor(svpFactory);

    private SignatureAttributesGenerator() {
    }

    public static void addSignatureAttributes(byte[] cmsSig, SignatureAttributesType signatureAttributesType) throws ParseException {
        SignatureAttributesGenerator.addSignatureAttributes(new CMSSignedData((Source)new BSource(cmsSig)), signatureAttributesType);
    }

    public static void addSignatureAttributes(CMSSignedData cmsSignedData, SignatureAttributesType signatureAttributesType) {
        SignedData signedData = cmsSignedData.getSignedData();
        if (signedData == null) {
            return;
        }
        for (SignerInfo signerInfo : signedData.getSignerInfoList()) {
            if (signerInfo == null) continue;
            SignatureAttributesGenerator.generateAttributesFromSI(signatureAttributesType, () -> ((SignerInfo)signerInfo).getSignedAttributes());
            SignatureAttributesGenerator.generateAttributesFromSI(signatureAttributesType, () -> ((SignerInfo)signerInfo).getUnsignedAttributes());
        }
    }

    private static void generateAttributesFromSI(SignatureAttributesType signatureAttributesType, Supplier<SignedAttributes> attributeGetter) {
        SignedAttributes signerInfoAttributes = attributeGetter.get();
        if (signerInfoAttributes == null) {
            return;
        }
        Map signerInfoAttributesMap = signerInfoAttributes.getAttributes();
        if (signerInfoAttributesMap == null) {
            return;
        }
        List signedAttrs = SignatureAttributesGenerator.createSignatureAttributes(signerInfoAttributesMap).getSigningTimeOrSigningCertificateOrDataObjectFormat();
        signatureAttributesType.getSigningTimeOrSigningCertificateOrDataObjectFormat().addAll(signedAttrs);
    }

    public static SignatureAttributesType createSignatureAttributes(Map<OBJECTIDENTIFIER, List<SignedAttribute>> attributes) {
        SignatureAttributesType sigAttrs = new SignatureAttributesType();
        List signatureAttrs = sigAttrs.getSigningTimeOrSigningCertificateOrDataObjectFormat();
        ArrayList allAttrs = new ArrayList();
        attributes.forEach((k, v) -> allAttrs.addAll(v));
        for (SignedAttribute attr : allAttrs) {
            JAXBElement<? extends AttributeBaseType> processedAttr = processor.process((ANY)attr);
            if (processedAttr == null) continue;
            signatureAttrs.add(processedAttr);
        }
        return sigAttrs;
    }

    static {
        processor.append(new ContentTypeProcessor(svpFactory)).append(new MimeTypeProcessor(svpFactory)).append(new CommitmentTypeIndicationProcessor(svpFactory)).append(new ContentTimestampProcessor(svpFactory)).append(new SignaturePolicyIdentifierProcessor(svpFactory)).append(new SignerLocationProcessor(svpFactory)).append(new SigningCertificateV1Processor(svpFactory)).append(new SigningCertificateV2Processor(svpFactory)).append(new SigningTimeProcessor(svpFactory)).append(new ArchiveTimeStampV2Processor(svpFactory)).append(new ArchiveTimeStampV3Processor(svpFactory)).append(new CAdESCTimestampProcessor(svpFactory)).append(new CertificateValuesProcessor(svpFactory)).append(new CompleteCertificateRefsProcessor(svpFactory)).append(new CompleteRevocationRefsProcessor(svpFactory)).append(new CounterSignatureProcessor(svpFactory)).append(new RevocationValuesProcessor(svpFactory)).append(new SignatureTimestampProcessor(svpFactory)).append(new TimestampedCertsCrlsReferencesProcessor(svpFactory)).append(new SignerAttributeV2Processor(svpFactory)).append(new AttributeCertificateRefsProcessor(svpFactory)).append(new AttributeRevocationRefsProcessor(svpFactory)).append(new LongTermValidationProcessor(svpFactory)).append(new CMSAlgorithmProtectionProcessor(svpFactory));
    }
}

