/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cades.attributes;

import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.cms.SignedAttribute;
import de.governikus.csl.cades.attributes.AttributeProcessor;
import de.governikus.csl.validate.svp.AttributeBaseType;
import de.governikus.csl.validate.svp.DataObjectFormatType;
import de.governikus.csl.validate.svp.ObjectFactory;
import javax.xml.bind.JAXBElement;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;

public class MimeTypeProcessor
implements AttributeProcessor {
    private static final ASN1ObjectIdentifier MIME_TYPE_OID = new ASN1ObjectIdentifier("0.4.0.1733.2.1");
    private final ObjectFactory svpFactory;
    private AttributeProcessor next;

    public MimeTypeProcessor(ObjectFactory svpFactory) {
        this.svpFactory = svpFactory;
    }

    @Override
    public AttributeProcessor append(AttributeProcessor next) {
        this.next = next;
        return next;
    }

    @Override
    public JAXBElement<? extends AttributeBaseType> process(ANY attribute) {
        SignedAttribute sAttr;
        JAXBElement result = null;
        if (attribute instanceof SignedAttribute && (sAttr = (SignedAttribute)attribute).getOID().equals(MIME_TYPE_OID.getId())) {
            DataObjectFormatType dataFormatAttribute = this.svpFactory.createDataObjectFormatType();
            dataFormatAttribute.setSigned(Boolean.TRUE);
            dataFormatAttribute.setMimeType(((ANY)sAttr.getValues().get(0)).getValueAsString());
            result = this.svpFactory.createSignatureAttributesTypeDataObjectFormat(dataFormatAttribute);
        }
        if (result == null && this.next != null) {
            result = this.next.process(attribute);
        }
        return result;
    }
}

