/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cades.attributes;

import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.cms.SignedAttribute;
import de.governikus.csl.cades.attributes.AttributeProcessor;
import de.governikus.csl.validate.svp.AttributeBaseType;
import de.governikus.csl.validate.svp.MessageDigestType;
import de.governikus.csl.validate.svp.ObjectFactory;
import javax.xml.bind.JAXBElement;
import org.bouncycastle.asn1.cms.CMSAttributes;

public class MessageDigestProcessor
implements AttributeProcessor {
    private final ObjectFactory svpFactory;
    private AttributeProcessor next;

    public MessageDigestProcessor(ObjectFactory svpFactory) {
        this.svpFactory = svpFactory;
    }

    @Override
    public AttributeProcessor append(AttributeProcessor next) {
        this.next = next;
        return next;
    }

    @Override
    public JAXBElement<? extends AttributeBaseType> process(ANY attribute) {
        SignedAttribute sAttr;
        JAXBElement result = null;
        if (attribute instanceof SignedAttribute && (sAttr = (SignedAttribute)attribute).getOID().equals(CMSAttributes.messageDigest.getId())) {
            MessageDigestType mdType = this.svpFactory.createMessageDigestType();
            mdType.setSigned(Boolean.TRUE);
            mdType.setDigestValue(((ANY)sAttr.getValues().get(0)).getValueAsByteArray());
            result = this.svpFactory.createSignatureAttributesTypeMessageDigest(mdType);
        }
        if (result == null && this.next != null) {
            result = this.next.process(attribute);
        }
        return result;
    }
}

