/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cades.attributes;

import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.cms.SignedAttribute;
import de.governikus.csl.cades.attributes.AbstractAttributeProcessor;
import de.governikus.csl.validate.svp.AttributeBaseType;
import de.governikus.csl.validate.svp.ObjectFactory;
import de.governikus.csl.validate.svp.TimeAttributeType;
import java.text.ParseException;
import javax.xml.bind.JAXBElement;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongTermValidationProcessor
extends AbstractAttributeProcessor {
    public static final ASN1ObjectIdentifier OID_LONG_TERM_VALIDATION = new ASN1ObjectIdentifier("0.4.0.1733.2.2");
    private final Logger log = LoggerFactory.getLogger(LongTermValidationProcessor.class);

    protected LongTermValidationProcessor(ObjectFactory svpFactory) {
        super(svpFactory);
    }

    @Override
    public JAXBElement<? extends AttributeBaseType> process(ANY attribute) {
        SignedAttribute sAttr;
        JAXBElement result = null;
        if (attribute instanceof SignedAttribute && (sAttr = (SignedAttribute)attribute).getOID().equals(OID_LONG_TERM_VALIDATION.getId())) {
            byte[] attributeValueBytes = ((ANY)sAttr.getValues().get(0)).getEncoded();
            ASN1Sequence longTermValidationValue = ASN1Sequence.getInstance((Object)attributeValueBytes);
            ASN1Encodable poeDateValue = longTermValidationValue.getObjectAt(0);
            ASN1GeneralizedTime poeDate = ASN1GeneralizedTime.getInstance((Object)poeDateValue);
            try {
                TimeAttributeType timeAttributeType = this.svpFactory.createTimeAttributeType();
                timeAttributeType.setSigned(Boolean.valueOf(false));
                timeAttributeType.setTime(poeDate.getDate());
                result = this.svpFactory.createSignatureAttributesTypeArchiveTimeStamp(timeAttributeType);
            }
            catch (ParseException e) {
                this.log.error("Could not parse CMS attribute", (Throwable)e);
            }
        }
        if (result == null && this.next != null) {
            result = this.next.process(attribute);
        }
        return result;
    }
}

