/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cades.attributes;

import de.bos_bremen.algorithm_identifier.AlgorithmService;
import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.cms.SignedAttribute;
import de.governikus.csl.cades.attributes.AttributeProcessor;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.validate.svp.AttributeBaseType;
import de.governikus.csl.validate.svp.CounterSignatureType;
import de.governikus.csl.validate.svp.ObjectFactory;
import de.governikus.csl.validate.svp.SignatureReferenceType;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;

public class CounterSignatureProcessor
implements AttributeProcessor {
    private static final ASN1ObjectIdentifier COUNTER_SIGNATURE_OID = new ASN1ObjectIdentifier("1.2.840.113549.1.9.6");
    private final ObjectFactory svpFactory;
    private final MessageDigest sha256Digest;
    private AttributeProcessor next;

    public CounterSignatureProcessor(ObjectFactory svpFactory) {
        this.svpFactory = svpFactory;
        try {
            this.sha256Digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Failed to initialize SHA-256 MessageDigest object.", e);
        }
    }

    @Override
    public AttributeProcessor append(AttributeProcessor next) {
        this.next = next;
        return next;
    }

    @Override
    public JAXBElement<? extends AttributeBaseType> process(ANY attribute) {
        SignedAttribute sAttr;
        JAXBElement result = null;
        if (attribute instanceof SignedAttribute && (sAttr = (SignedAttribute)attribute).getOID().equals(COUNTER_SIGNATURE_OID.getId())) {
            CounterSignatureType counterSignatureType = this.svpFactory.createCounterSignatureType();
            counterSignatureType.setSigned(Boolean.FALSE);
            List counterSignatureList = counterSignatureType.getCounterSignature();
            List attributeValues = sAttr.getValues();
            for (ANY attributeValue : attributeValues) {
                byte[] attributeValueBytes = attributeValue.getEncoded();
                byte[] attributeHash = this.sha256Digest.digest(attributeValueBytes);
                SignatureReferenceType sigReference = this.svpFactory.createSignatureReferenceType();
                sigReference.setDigestValue(attributeHash);
                DigestAlgorithm digestAlgo = AlgorithmService.getDigestForJCAName((String)"SHA-256");
                de.governikus.csl.validate.svp.DigestAlgorithm digestAlgoSVP = SVPFactory.createDigestAlgorithm((DigestAlgorithm)digestAlgo);
                sigReference.setDigestMethod(digestAlgoSVP);
                counterSignatureList.add(sigReference);
            }
            result = this.svpFactory.createSignatureAttributesTypeCounterSignature(counterSignatureType);
        }
        if (result == null && this.next != null) {
            result = this.next.process(attribute);
        }
        return result;
    }
}

