/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cades.attributes;

import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.cms.SignedAttribute;
import de.governikus.csl.cades.attributes.AttributeProcessor;
import de.governikus.csl.validate.svp.AttributeBaseType;
import de.governikus.csl.validate.svp.DataObjectFormatType;
import de.governikus.csl.validate.svp.ObjectFactory;
import javax.xml.bind.JAXBElement;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.CMSAttributes;

public class ContentTypeProcessor
implements AttributeProcessor {
    private final ObjectFactory svpFactory;
    private AttributeProcessor next;

    public ContentTypeProcessor(ObjectFactory svpFactory) {
        this.svpFactory = svpFactory;
    }

    @Override
    public AttributeProcessor append(AttributeProcessor next) {
        this.next = next;
        return next;
    }

    @Override
    public JAXBElement<? extends AttributeBaseType> process(ANY attribute) {
        SignedAttribute sAttr;
        JAXBElement result = null;
        if (attribute instanceof SignedAttribute && (sAttr = (SignedAttribute)attribute).getOID().equals(CMSAttributes.contentType.getId())) {
            DataObjectFormatType dataFormatType = this.svpFactory.createDataObjectFormatType();
            dataFormatType.setSigned(Boolean.TRUE);
            ASN1ObjectIdentifier oidObject = ASN1ObjectIdentifier.getInstance((Object)((ANY)sAttr.getValues().get(0)).getEncoded());
            dataFormatType.setContentType(oidObject.getId());
            result = this.svpFactory.createSignatureAttributesTypeDataObjectFormat(dataFormatType);
        }
        if (result == null && this.next != null) {
            result = this.next.process(attribute);
        }
        return result;
    }
}

