/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cades.attributes;

import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.cms.SignedAttribute;
import de.governikus.csl.cades.attributes.AttributeProcessor;
import de.governikus.csl.validate.svp.AttributeBaseType;
import de.governikus.csl.validate.svp.CommitmentType;
import de.governikus.csl.validate.svp.CommitmentTypeIndicationType;
import de.governikus.csl.validate.svp.ObjectFactory;
import javax.xml.bind.JAXBElement;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.esf.CommitmentTypeIndication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitmentTypeIndicationProcessor
implements AttributeProcessor {
    private static final Logger logger = LoggerFactory.getLogger(CommitmentTypeIndicationProcessor.class);
    private static final ASN1ObjectIdentifier COMMITMENT_TYPE_INDICATION_OID = new ASN1ObjectIdentifier("1.2.840.113549.1.9.16.2.16");
    private final ObjectFactory svpFactory;
    private AttributeProcessor next;

    public CommitmentTypeIndicationProcessor(ObjectFactory svpFactory) {
        this.svpFactory = svpFactory;
    }

    @Override
    public AttributeProcessor append(AttributeProcessor next) {
        this.next = next;
        return next;
    }

    @Override
    public JAXBElement<? extends AttributeBaseType> process(ANY attribute) {
        SignedAttribute sAttr;
        JAXBElement result = null;
        if (attribute instanceof SignedAttribute && (sAttr = (SignedAttribute)attribute).getOID().equals(COMMITMENT_TYPE_INDICATION_OID.getId())) {
            byte[] ctiSeq = ((ANY)sAttr.getValues().get(0)).getEncoded();
            CommitmentTypeIndication cti = CommitmentTypeIndication.getInstance((Object)ctiSeq);
            CommitmentTypeIndicationType ctiAttribute = this.svpFactory.createCommitmentTypeIndicationType();
            ctiAttribute.setSigned(Boolean.TRUE);
            CommitmentType commitmentType = null;
            switch (cti.getCommitmentTypeId().getId()) {
                case "1.2.840.113549.1.9.16.6.1": {
                    commitmentType = CommitmentType.PROOF_OF_ORIGIN;
                    break;
                }
                case "1.2.840.113549.1.9.16.6.2": {
                    commitmentType = CommitmentType.PROOF_OF_RECEIPT;
                    break;
                }
                case "1.2.840.113549.1.9.16.6.3": {
                    commitmentType = CommitmentType.PROOF_OF_DELIVERY;
                    break;
                }
                case "1.2.840.113549.1.9.16.6.4": {
                    commitmentType = CommitmentType.PROOF_OF_SENDER;
                    break;
                }
                case "1.2.840.113549.1.9.16.6.5": {
                    commitmentType = CommitmentType.PROOF_OF_APPROVAL;
                    break;
                }
                case "1.2.840.113549.1.9.16.6.6": {
                    commitmentType = CommitmentType.PROOF_OF_CREATION;
                    break;
                }
                default: {
                    logger.warn("Unrecognized CommitmentTypeIndication with OID " + cti.getCommitmentTypeId().getId() + "found. The signature attribute creation is skipped for this property.");
                }
            }
            if (commitmentType != null) {
                ctiAttribute.setCommitment(commitmentType);
                result = this.svpFactory.createSignatureAttributesTypeCommitmentTypeIndication(ctiAttribute);
            }
        }
        if (result == null && this.next != null) {
            result = this.next.process(attribute);
        }
        return result;
    }
}

