/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cades.attributes;

import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.cms.SignedAttribute;
import de.governikus.csl.cades.attributes.AttributeProcessor;
import de.governikus.csl.validate.svp.AttributeBaseType;
import de.governikus.csl.validate.svp.CertificateValuesType;
import de.governikus.csl.validate.svp.ObjectFactory;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateValuesProcessor
implements AttributeProcessor {
    private static final Logger logger = LoggerFactory.getLogger(CertificateValuesProcessor.class);
    private static final ASN1ObjectIdentifier CERT_VALUES_OID = new ASN1ObjectIdentifier("1.2.840.113549.1.9.16.2.23");
    private final ObjectFactory svpFactory;
    private AttributeProcessor next;

    public CertificateValuesProcessor(ObjectFactory svpFactory) {
        this.svpFactory = svpFactory;
    }

    @Override
    public AttributeProcessor append(AttributeProcessor next) {
        this.next = next;
        return next;
    }

    @Override
    public JAXBElement<? extends AttributeBaseType> process(ANY attribute) {
        SignedAttribute sAttr;
        JAXBElement result = null;
        if (attribute instanceof SignedAttribute && (sAttr = (SignedAttribute)attribute).getOID().equals(CERT_VALUES_OID.getId())) {
            byte[] certValuesBytes = ((ANY)sAttr.getValues().get(0)).getEncoded();
            ASN1Sequence certificateValues = ASN1Sequence.getInstance((Object)certValuesBytes);
            CertificateValuesType certValuesType = this.svpFactory.createCertificateValuesType();
            certValuesType.setSigned(Boolean.FALSE);
            List certs = certValuesType.getCertificateValue();
            Iterator elemIter = certificateValues.iterator();
            while (elemIter.hasNext()) {
                try {
                    certs.add(((ASN1Encodable)elemIter.next()).toASN1Primitive().getEncoded());
                }
                catch (IOException e) {
                    logger.warn("Failed to reencode certificate to byte array. The certificate will be ignored.", (Throwable)e);
                }
            }
            result = this.svpFactory.createSignatureAttributesTypeCertificateValues(certValuesType);
        }
        if (result == null && this.next != null) {
            result = this.next.process(attribute);
        }
        return result;
    }
}

