/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cades.attributes;

import de.bos_bremen.algorithm_identifier.Algorithm;
import de.bos_bremen.algorithm_identifier.AlgorithmService;
import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.bos_bremen.algorithm_identifier.SignatureAlgorithm;
import de.bos_bremen.algorithm_identifier.gen.SignatureAlgorithmImpl;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.cms.SignedAttribute;
import de.governikus.csl.cades.attributes.AttributeProcessor;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.validate.svp.AttributeBaseType;
import de.governikus.csl.validate.svp.CMSAlgorithmProtectionType;
import de.governikus.csl.validate.svp.ObjectFactory;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBElement;
import org.bouncycastle.asn1.cms.CMSAlgorithmProtection;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMSAlgorithmProtectionProcessor
implements AttributeProcessor {
    private static final Logger logger = LoggerFactory.getLogger(CMSAlgorithmProtectionProcessor.class);
    private final ObjectFactory svpFactory;
    private AttributeProcessor next;

    public CMSAlgorithmProtectionProcessor(ObjectFactory svpFactory) {
        this.svpFactory = svpFactory;
    }

    @Override
    public AttributeProcessor append(AttributeProcessor next) {
        this.next = next;
        return next;
    }

    @Override
    public JAXBElement<? extends AttributeBaseType> process(ANY attribute) {
        SignedAttribute sAttr;
        JAXBElement<? extends AttributeBaseType> result = null;
        if (attribute instanceof SignedAttribute && (sAttr = (SignedAttribute)attribute).getOID().equals(CMSAttributes.cmsAlgorithmProtect.getId())) {
            byte[] attributeValueBytes = ((ANY)sAttr.getValues().get(0)).getEncoded();
            CMSAlgorithmProtection instance = null;
            try {
                instance = CMSAlgorithmProtection.getInstance((Object)attributeValueBytes);
            }
            catch (Exception e) {
                logger.error("CMSAlgorithmProtection attribute could not be parsed. The signature attribute creation is skipped for this property.", (Throwable)e);
            }
            if (instance != null) {
                result = this.processCMSAlgorithmProtection(result, instance);
            }
        }
        if (result == null && this.next != null) {
            result = this.next.process(attribute);
        }
        return result;
    }

    private JAXBElement<? extends AttributeBaseType> processCMSAlgorithmProtection(JAXBElement<? extends AttributeBaseType> result, CMSAlgorithmProtection instance) {
        AlgorithmIdentifier bcDigestAlgorithm = instance.getDigestAlgorithm();
        AlgorithmIdentifier bcSignatureAlgorithm = instance.getSignatureAlgorithm();
        if (bcSignatureAlgorithm != null) {
            DigestAlgorithm digestForOID = AlgorithmService.getDigestForOID((String)bcDigestAlgorithm.getAlgorithm().getId());
            List signatureForOID = AlgorithmService.getSignatureForOID((String)bcSignatureAlgorithm.getAlgorithm().getId());
            if (digestForOID != null && signatureForOID != null && !signatureForOID.isEmpty()) {
                if ((signatureForOID = signatureForOID.stream().filter(SignatureAlgorithmImpl.class::isInstance).collect(Collectors.toList())).size() > 1 && logger.isWarnEnabled()) {
                    logger.warn("For OID {} ambiguous algorithms were found: {} \n Trying to use the first one.", (Object)bcSignatureAlgorithm.getAlgorithm().getId(), (Object)signatureForOID.stream().map(Algorithm::getName).collect(Collectors.joining(", ", "[", "]")));
                }
                result = this.wrapToResult(result, digestForOID, (Algorithm)signatureForOID.get(0));
            } else {
                logger.warn("AlgorithmService can not find algorithm for OID {}", (Object)(digestForOID == null ? bcDigestAlgorithm.getAlgorithm().getId() : bcSignatureAlgorithm.getAlgorithm().getId()));
            }
        } else {
            AlgorithmIdentifier macAlgorithm = instance.getMacAlgorithm();
            if (macAlgorithm != null) {
                logger.debug("CMSAlgorithmProtection contains mac algorithm {}. Neglecting this attribute.", (Object)macAlgorithm.getAlgorithm().getId());
            }
        }
        return result;
    }

    private JAXBElement<? extends AttributeBaseType> wrapToResult(JAXBElement<? extends AttributeBaseType> result, DigestAlgorithm digestForOID, Algorithm signatureForOID) {
        if (signatureForOID != null) {
            de.governikus.csl.validate.svp.DigestAlgorithm digestAlgorithm = SVPFactory.createDigestAlgorithm((DigestAlgorithm)digestForOID);
            de.governikus.csl.validate.svp.SignatureAlgorithm signatureAlgorithm = SVPFactory.createSignatureAlgorithm((SignatureAlgorithm)((SignatureAlgorithm)signatureForOID));
            CMSAlgorithmProtectionType cmsAlgorithmProtectionType = this.svpFactory.createCMSAlgorithmProtectionType();
            cmsAlgorithmProtectionType.setSigned(Boolean.valueOf(true));
            cmsAlgorithmProtectionType.setDigestMethod(digestAlgorithm);
            cmsAlgorithmProtectionType.setSignatureMethod(signatureAlgorithm);
            result = this.svpFactory.createSignatureAttributesTypeCmsAlgorithmProtection(cmsAlgorithmProtectionType);
        } else {
            logger.warn("Expected signature algorithm is null");
        }
        return result;
    }
}

