/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cades.attributes;

import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.cms.SignedAttribute;
import de.governikus.csl.cades.attributes.AbstractTimestampProcessor;
import de.governikus.csl.validate.svp.AttributeBaseType;
import de.governikus.csl.validate.svp.ObjectFactory;
import de.governikus.csl.validate.svp.TimeAttributeType;
import java.io.IOException;
import java.util.Date;
import javax.xml.bind.JAXBElement;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.tsp.TSPException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAdESCTimestampProcessor
extends AbstractTimestampProcessor {
    private static final Logger logger = LoggerFactory.getLogger(CAdESCTimestampProcessor.class);
    private static final ASN1ObjectIdentifier CADES_C_TST_OID = new ASN1ObjectIdentifier("1.2.840.113549.1.9.16.2.25");

    public CAdESCTimestampProcessor(ObjectFactory svpFactory) {
        super(svpFactory);
    }

    @Override
    public JAXBElement<? extends AttributeBaseType> process(ANY attribute) {
        SignedAttribute sAttr;
        JAXBElement result = null;
        if (attribute instanceof SignedAttribute && (sAttr = (SignedAttribute)attribute).getOID().equals(CADES_C_TST_OID.getId())) {
            byte[] tstBytes = ((ANY)sAttr.getValues().get(0)).getEncoded();
            try {
                Date tstDateTime = this.extractDateTime(tstBytes);
                TimeAttributeType sigAndRefsTstAttr = this.svpFactory.createTimeAttributeType();
                sigAndRefsTstAttr.setSigned(Boolean.FALSE);
                sigAndRefsTstAttr.setTime(tstDateTime);
                result = this.svpFactory.createSignatureAttributesTypeSigAndRefsTimeStamp(sigAndRefsTstAttr);
            }
            catch (IOException | CMSException | TSPException e) {
                logger.error("Failed to parse CAdES-C-Timestamp Attribute.", e);
            }
        }
        if (result == null && this.next != null) {
            result = this.next.process(attribute);
        }
        return result;
    }
}

