/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cades.attributes;

import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.cms.SignedAttribute;
import de.governikus.csl.cades.attributes.AbstractTimestampProcessor;
import de.governikus.csl.validate.svp.AttributeBaseType;
import de.governikus.csl.validate.svp.ObjectFactory;
import de.governikus.csl.validate.svp.TimeAttributeType;
import java.io.IOException;
import java.util.Date;
import javax.xml.bind.JAXBElement;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.tsp.TSPException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveTimeStampV3Processor
extends AbstractTimestampProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ArchiveTimeStampV3Processor.class);
    private static final ASN1ObjectIdentifier ARCHIVE_TST_V3_OID = new ASN1ObjectIdentifier("0.4.0.1733.2.4");

    public ArchiveTimeStampV3Processor(ObjectFactory svpFactory) {
        super(svpFactory);
    }

    @Override
    public JAXBElement<? extends AttributeBaseType> process(ANY attribute) {
        SignedAttribute sAttr;
        JAXBElement result = null;
        if (attribute instanceof SignedAttribute && (sAttr = (SignedAttribute)attribute).getOID().equals(ARCHIVE_TST_V3_OID.getId())) {
            byte[] tstBytes = ((ANY)sAttr.getValues().get(0)).getEncoded();
            try {
                Date tstDateTime = this.extractDateTime(tstBytes);
                TimeAttributeType archiveTstAttr = this.svpFactory.createTimeAttributeType();
                archiveTstAttr.setSigned(Boolean.FALSE);
                archiveTstAttr.setTime(tstDateTime);
                result = this.svpFactory.createSignatureAttributesTypeArchiveTimeStamp(archiveTstAttr);
            }
            catch (IOException | CMSException | TSPException e) {
                logger.error("Failed to parse ArchiveTimeStampV3 Attribute.", e);
            }
        }
        if (result == null && this.next != null) {
            result = this.next.process(attribute);
        }
        return result;
    }
}

