/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cades.attributes;

import de.bos_bremen.algorithm_identifier.AlgorithmService;
import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.cms.SignedAttribute;
import de.governikus.csl.cades.attributes.AttributeProcessor;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.validate.svp.AttributeBaseType;
import de.governikus.csl.validate.svp.CRLIDType;
import de.governikus.csl.validate.svp.OCSPIDType;
import de.governikus.csl.validate.svp.ObjectFactory;
import de.governikus.csl.validate.svp.RevIDListType;
import java.io.Serializable;
import java.text.ParseException;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.esf.CompleteRevocationRefs;
import org.bouncycastle.asn1.esf.CrlListID;
import org.bouncycastle.asn1.esf.CrlOcspRef;
import org.bouncycastle.asn1.esf.CrlValidatedID;
import org.bouncycastle.asn1.esf.OcspIdentifier;
import org.bouncycastle.asn1.esf.OcspListID;
import org.bouncycastle.asn1.esf.OcspResponsesID;
import org.bouncycastle.asn1.esf.OtherHash;
import org.bouncycastle.asn1.ocsp.ResponderID;
import org.bouncycastle.asn1.x500.X500Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRevocationRefsProcessor
implements AttributeProcessor {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRevocationRefsProcessor.class);
    protected final ObjectFactory svpFactory;
    protected AttributeProcessor next;

    public AbstractRevocationRefsProcessor(ObjectFactory svpFactory) {
        this.svpFactory = svpFactory;
    }

    protected abstract JAXBElement<? extends AttributeBaseType> createResult(RevIDListType var1);

    protected abstract ASN1ObjectIdentifier getOID();

    @Override
    public AttributeProcessor append(AttributeProcessor next) {
        this.next = next;
        return next;
    }

    @Override
    public JAXBElement<? extends AttributeBaseType> process(ANY attribute) {
        SignedAttribute sAttr;
        JAXBElement<? extends AttributeBaseType> result = null;
        if (attribute instanceof SignedAttribute && (sAttr = (SignedAttribute)attribute).getOID().equals(this.getOID().getId())) {
            byte[] attributeValueBytes = ((ANY)sAttr.getValues().get(0)).getEncoded();
            CompleteRevocationRefs completeRevocationRefs = CompleteRevocationRefs.getInstance((Object)attributeValueBytes);
            CrlOcspRef[] crlOcspRefs = completeRevocationRefs.getCrlOcspRefs();
            RevIDListType revIDList = this.svpFactory.createRevIDListType();
            revIDList.setSigned(Boolean.FALSE);
            List crlIdOrOcspIdList = revIDList.getCRLIDOrOCSPID();
            this.extractCrlIdOrOcspId(crlOcspRefs, crlIdOrOcspIdList);
            result = this.createResult(revIDList);
        }
        if (result == null && this.next != null) {
            result = this.next.process(attribute);
        }
        return result;
    }

    private void extractCrlIdOrOcspId(CrlOcspRef[] crlOcspRefs, List<Serializable> crlIdOrOcspIdList) {
        for (CrlOcspRef crlOcspRef : crlOcspRefs) {
            this.extractCrlIds(crlIdOrOcspIdList, crlOcspRef);
            this.extractOcspIds(crlIdOrOcspIdList, crlOcspRef);
        }
    }

    private void extractOcspIds(List<Serializable> crlIdOrOcspIdList, CrlOcspRef crlOcspRef) {
        OcspListID ocspids = crlOcspRef.getOcspids();
        if (ocspids != null) {
            for (OcspResponsesID ocspResponsesId : ocspids.getOcspResponses()) {
                OcspIdentifier ocspIdentifier = ocspResponsesId.getOcspIdentifier();
                ASN1GeneralizedTime producedAt = ocspIdentifier.getProducedAt();
                ResponderID ocspResponderID = ocspIdentifier.getOcspResponderID();
                byte[] keyHash = ocspResponderID.getKeyHash();
                X500Name responderName = ocspResponderID.getName();
                OCSPIDType ocspId = this.svpFactory.createOCSPIDType();
                try {
                    ocspId.setProducedAt(producedAt.getDate());
                }
                catch (ParseException e) {
                    logger.warn("Failed to get producedAt property from ocspIdentifier of CompleteRevocationRefs attribute. The property will be ignored.");
                }
                ocspId.setResponderIDByKey(keyHash);
                if (responderName != null) {
                    ocspId.setResponderIDByName(responderName.toString());
                }
                crlIdOrOcspIdList.add((Serializable)ocspId);
            }
        }
    }

    private void extractCrlIds(List<Serializable> crlIdOrOcspIdList, CrlOcspRef crlOcspRef) {
        CrlListID crlids = crlOcspRef.getCrlids();
        if (crlids != null) {
            for (CrlValidatedID crlValidatedId : crlids.getCrls()) {
                OtherHash crlHash = crlValidatedId.getCrlHash();
                String hashOid = crlHash.getHashAlgorithm().getAlgorithm().getId();
                byte[] crlHashValue = crlHash.getHashValue();
                CRLIDType crlId = this.svpFactory.createCRLIDType();
                DigestAlgorithm hashAlgorithm = AlgorithmService.getDigestForOID((String)hashOid);
                de.governikus.csl.validate.svp.DigestAlgorithm digestAlgo = SVPFactory.createDigestAlgorithm((DigestAlgorithm)hashAlgorithm);
                crlId.setDigestMethod(digestAlgo);
                crlId.setDigestValue(crlHashValue);
                crlIdOrOcspIdList.add((Serializable)crlId);
            }
        }
    }
}

