/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cades.attributes;

import de.bos_bremen.algorithm_identifier.AlgorithmService;
import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.cms.SignedAttribute;
import de.governikus.csl.cades.attributes.AttributeProcessor;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.validate.svp.AttributeBaseType;
import de.governikus.csl.validate.svp.CertIDListType;
import de.governikus.csl.validate.svp.CertIDType;
import de.governikus.csl.validate.svp.ObjectFactory;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ess.OtherCertID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCertificateRefsProcessor
implements AttributeProcessor {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractCertificateRefsProcessor.class);
    protected final ObjectFactory svpFactory;
    protected AttributeProcessor next;

    public AbstractCertificateRefsProcessor(ObjectFactory svpFactory) {
        this.svpFactory = svpFactory;
    }

    protected abstract JAXBElement<? extends AttributeBaseType> createResult(CertIDListType var1);

    protected abstract ASN1ObjectIdentifier getOID();

    @Override
    public AttributeProcessor append(AttributeProcessor next) {
        this.next = next;
        return next;
    }

    @Override
    public JAXBElement<? extends AttributeBaseType> process(ANY attribute) {
        SignedAttribute sAttr;
        JAXBElement<? extends AttributeBaseType> result = null;
        if (attribute instanceof SignedAttribute && (sAttr = (SignedAttribute)attribute).getOID().equals(this.getOID().getId())) {
            byte[] attributeValueBytes = ((ANY)sAttr.getValues().get(0)).getEncoded();
            CertIDListType certIDListType = this.svpFactory.createCertIDListType();
            certIDListType.setSigned(Boolean.FALSE);
            List certIdList = certIDListType.getCertID();
            this.processCertIDs(attributeValueBytes, certIdList);
            result = this.createResult(certIDListType);
        }
        if (result == null && this.next != null) {
            result = this.next.process(attribute);
        }
        return result;
    }

    private void processCertIDs(byte[] attributeValueBytes, List<CertIDType> certIdList) {
        ASN1Sequence completeCertRefsAttrValue = ASN1Sequence.getInstance((Object)attributeValueBytes);
        Iterator certIdsIter = completeCertRefsAttrValue.iterator();
        while (certIdsIter.hasNext()) {
            OtherCertID otherCertId = OtherCertID.getInstance(certIdsIter.next());
            String hashOid = otherCertId.getAlgorithmHash().getAlgorithm().getId();
            DigestAlgorithm hashAlgorithm = AlgorithmService.getDigestForOID((String)hashOid);
            de.governikus.csl.validate.svp.DigestAlgorithm svpDigestAlgo = SVPFactory.createDigestAlgorithm((DigestAlgorithm)hashAlgorithm);
            byte[] digestValue = otherCertId.getCertHash();
            CertIDType certIDType = this.svpFactory.createCertIDType();
            certIDType.setDigestMethod(svpDigestAlgo);
            certIDType.setDigestValue(digestValue);
            if (otherCertId.getIssuerSerial() != null) {
                try {
                    certIDType.setX509IssuerSerial(otherCertId.getIssuerSerial().getEncoded());
                }
                catch (IOException e) {
                    logger.warn("Failed to reencode the IssuerSerial field into a byte array. The value will be ignored.");
                }
            }
            certIdList.add(certIDType);
        }
    }
}

