/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cades.ats;

import de.bos_bremen.ci.asn1.cms.AtsHashIndex;
import de.bos_bremen.ci.asn1.cms.SignedData;
import de.bos_bremen.ci.asn1.cms.SignerInfo;
import de.governikus.csl.cades.CAdESArchiveTimestamp;
import de.governikus.csl.cades.CMSSignature;
import de.governikus.csl.cades.ats.AtsHashIndexValidationResult;
import de.governikus.csl.cades.ats.AtsHashIndexValidator;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.uom.validate.commons.Timestamp;
import de.governikus.csl.validate.svp.TimestampValidationResult;
import de.governikus.csl.validate.svp.ValidationResult;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.criteria.AbstractValidationCriterion;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class CheckAtsHashIndex
extends AbstractValidationCriterion<Timestamp, TimestampValidationResult, SignatureValidationContext> {
    public void verify(Timestamp signature, TimestampValidationResult result, SignatureValidationContext context) {
        List atsHashIndizes = signature.getAtsHashIndizes();
        CAdESArchiveTimestamp archiveTimestamp = (CAdESArchiveTimestamp)signature;
        CMSSignature protectedSignature = archiveTimestamp.getSignature();
        SignedData signedData = protectedSignature.getSignedData();
        AtsHashIndexValidator validator = new AtsHashIndexValidator((SignerInfo)signedData.getSignerInfoList().get(0), signedData.getCertificates(), signedData.getCRLs(), context.getConfiguration().getAlgorithmManager());
        HashSet<String> validationMessages = new HashSet<String>();
        for (AtsHashIndex hashIndex : atsHashIndizes) {
            AtsHashIndexValidationResult res = validator.validate(hashIndex);
            if (!res.isAllCertificatesAvailable()) {
                validationMessages.add("cades_archive_ts_ats_certs_not_covered");
            }
            if (!res.isAllCRLsAvailable()) {
                validationMessages.add("cades_archive_ts_ats_crls_not_covered");
            }
            if (res.isAllUnsignedPropertiesAvailable()) continue;
            validationMessages.add("cades_archive_ts_ats_unsigned_props_not_covered");
        }
        ValidationResult vr = null;
        vr = validationMessages.isEmpty() ? SVPFactory.createResultOk() : SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.FORMAT_FAILURE, new ArrayList(validationMessages));
        result.setAtsHashIndexValidationResult(vr);
    }
}

