/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cades.ats;

import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.bos_bremen.ci.BSource;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.Source;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.AlgorithmIdentifier;
import de.bos_bremen.ci.asn1.OBJECTIDENTIFIER;
import de.bos_bremen.ci.asn1.OCTETSTRING;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.cms.AtsHashIndex;
import de.bos_bremen.ci.asn1.cms.CertificateSet;
import de.bos_bremen.ci.asn1.cms.SignedAttribute;
import de.bos_bremen.ci.asn1.cms.SignerInfo;
import de.bos_bremen.ci.asn1.cms.UnsignedAttributes;
import de.bos_bremen.ci.asn1.crl.CertificateList;
import de.bos_bremen.ci.asn1.crl.RevocationInfoChoices;
import de.bos_bremen.ci.asn1.x509.FlatCertificate;
import de.governikus.csl.cades.ats.AtsHashIndexValidationResult;
import de.governikus.csl.uom.core.AlgorithmServiceFacade;
import de.governikus.csl.uom.validate.commons.AlgorithmManager;
import de.governikus.csl.utils.ByteArrayKey;
import de.governikus.csl.utils.DigestUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtsHashIndexValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AtsHashIndexValidator.class);
    private static OBJECTIDENTIFIER BASIC_OCSP_RESP_OID;
    private static OBJECTIDENTIFIER OCSP_RESP_OID;
    private SignerInfo signerInfo;
    private CertificateSet certificates;
    private RevocationInfoChoices crLs;
    private AlgorithmManager algorithmManager;

    public AtsHashIndexValidator(SignerInfo signerInfo, CertificateSet certificates, RevocationInfoChoices crLs) {
        this.signerInfo = signerInfo;
        this.certificates = certificates;
        this.crLs = crLs;
        this.algorithmManager = new AlgorithmServiceFacade();
    }

    public AtsHashIndexValidator(SignerInfo signerInfo, CertificateSet certificates, RevocationInfoChoices crLs, AlgorithmManager algorithmManager) {
        this.signerInfo = signerInfo;
        this.certificates = certificates;
        this.crLs = crLs;
        this.algorithmManager = algorithmManager;
    }

    public AtsHashIndexValidationResult validate(AtsHashIndex hashIndex) {
        AlgorithmIdentifier hashAlgorithm = hashIndex.getHashAlgorithm();
        DigestAlgorithm digestAlgorithm = this.algorithmManager.getDigestAlgorithmByOID(hashAlgorithm.getOID().getOID());
        List certificatesHashIndex = hashIndex.getCertificatesHashIndex();
        boolean allCertsAvailable = this.validateCertificates(certificatesHashIndex, digestAlgorithm);
        boolean allCrlsAvailable = this.validateCRLs(hashIndex.getCrlsHashIndex(), digestAlgorithm);
        boolean allUnsignedPropertiesAvailable = false;
        int version = hashIndex.getVersion();
        if (version == 1 || version == 2) {
            allUnsignedPropertiesAvailable = this.validateUnsignedPropertiesV1(hashIndex.getUnsignedAttributesHashIndex(), digestAlgorithm);
        } else if (version == 3) {
            allUnsignedPropertiesAvailable = this.validateUnsignedPropertiesV3(hashIndex.getUnsignedAttributesHashIndex(), digestAlgorithm);
        }
        return new AtsHashIndexValidationResult(allCertsAvailable, allCrlsAvailable, allUnsignedPropertiesAvailable);
    }

    private boolean validateUnsignedPropertiesV3(List<OCTETSTRING> unsignedAttributesHashIndex, DigestAlgorithm digestAlgorithm) {
        return this.validateUnsignedProperties(unsignedAttributesHashIndex, digestAlgorithm, this::createUnsignedAttributeHashMapV3);
    }

    private boolean validateUnsignedProperties(List<OCTETSTRING> unsignedAttributesHashIndex, DigestAlgorithm digestAlgorithm, BiFunction<UnsignedAttributes, DigestAlgorithm, Map<ByteArrayKey, byte[]>> mapCreator) {
        if (unsignedAttributesHashIndex == null || unsignedAttributesHashIndex.isEmpty()) {
            return true;
        }
        UnsignedAttributes unsignedAttributes = this.signerInfo.getUnsignedAttributes();
        Map<ByteArrayKey, byte[]> availableCertificates = mapCreator.apply(unsignedAttributes, digestAlgorithm);
        boolean valid = true;
        for (OCTETSTRING os : unsignedAttributesHashIndex) {
            byte[] cert = availableCertificates.get(new ByteArrayKey(os.getOctets()));
            if (cert != null) continue;
            valid = false;
        }
        return valid;
    }

    private Map<ByteArrayKey, byte[]> createUnsignedAttributeHashMapV1(UnsignedAttributes unsignedAttributes, DigestAlgorithm digestAlgorithm) {
        HashMap<ByteArrayKey, byte[]> availableCertificates = new HashMap<ByteArrayKey, byte[]>();
        Map attributes = unsignedAttributes.getAttributes();
        for (Map.Entry entry : attributes.entrySet()) {
            List attributeList = (List)entry.getValue();
            for (SignedAttribute sa : attributeList) {
                byte[] encoded2 = sa.getEncoded();
                availableCertificates.put(new ByteArrayKey(DigestUtil.createHash((byte[])encoded2, (DigestAlgorithm)digestAlgorithm)), encoded2);
            }
        }
        return availableCertificates;
    }

    private Map<ByteArrayKey, byte[]> createUnsignedAttributeHashMapV3(UnsignedAttributes unsignedAttributes, DigestAlgorithm digestAlgorithm) {
        HashMap<ByteArrayKey, byte[]> availableCertificates = new HashMap<ByteArrayKey, byte[]>();
        Map attributes = unsignedAttributes.getAttributes();
        for (Map.Entry entry : attributes.entrySet()) {
            List attributeList = (List)entry.getValue();
            byte[] key = ((OBJECTIDENTIFIER)entry.getKey()).getEncoded();
            for (SignedAttribute sa : attributeList) {
                List values = sa.getValues();
                for (ANY any : values) {
                    byte[] encoded = any.getEncoded();
                    availableCertificates.put(new ByteArrayKey(DigestUtil.createHashQuietly((DigestAlgorithm)digestAlgorithm, (byte[][])new byte[][]{key, encoded})), encoded);
                }
            }
        }
        return availableCertificates;
    }

    private boolean validateUnsignedPropertiesV1(List<OCTETSTRING> unsignedAttributesHashIndex, DigestAlgorithm digestAlgorithm) {
        return this.validateUnsignedProperties(unsignedAttributesHashIndex, digestAlgorithm, this::createUnsignedAttributeHashMapV1);
    }

    private boolean validateCertificates(List<OCTETSTRING> certificatesHashIndex, DigestAlgorithm digestAlgorithm) {
        if (certificatesHashIndex == null || certificatesHashIndex.isEmpty()) {
            return true;
        }
        List certificateChoices = this.certificates.getCertificateChoices();
        Map availableCertificates = certificateChoices.stream().map(FlatCertificate::getEncoded).collect(Collectors.toMap(x -> new ByteArrayKey(DigestUtil.createHash((byte[])x, (DigestAlgorithm)digestAlgorithm)), Function.identity()));
        boolean valid = true;
        for (OCTETSTRING os : certificatesHashIndex) {
            byte[] cert = (byte[])availableCertificates.get(new ByteArrayKey(os.getOctets()));
            if (cert != null) continue;
            valid = false;
        }
        return valid;
    }

    private boolean validateCRLs(List<OCTETSTRING> crlHashIndex, DigestAlgorithm digestAlgorithm) {
        if (crlHashIndex == null || crlHashIndex.isEmpty()) {
            return true;
        }
        if (this.crLs == null) {
            return false;
        }
        List certificatesLists = this.crLs.getCertificatesLists();
        Map<ByteArrayKey, byte[]> availableCrls = certificatesLists.stream().map(CertificateList::getEncoded).collect(Collectors.toMap(x -> new ByteArrayKey(DigestUtil.createHash((byte[])x, (DigestAlgorithm)digestAlgorithm)), Function.identity()));
        List otherRevocationInfoFormats = this.crLs.getOtherRevocationInfoFormats(OCSP_RESP_OID);
        Map<ByteArrayKey, byte[]> availableOCSPResponses = otherRevocationInfoFormats.stream().map(x -> x.getOtherRevInfo().getEncoded()).collect(Collectors.toMap(x -> new ByteArrayKey(DigestUtil.createHash((byte[])x, (DigestAlgorithm)digestAlgorithm)), Function.identity()));
        otherRevocationInfoFormats = this.crLs.getOtherRevocationInfoFormats(BASIC_OCSP_RESP_OID);
        Map<ByteArrayKey, byte[]> availableBasicOCSPResponses = otherRevocationInfoFormats.stream().map(x -> x.getOtherRevInfo().getEncoded()).collect(Collectors.toMap(x -> new ByteArrayKey(DigestUtil.createHash((byte[])x, (DigestAlgorithm)digestAlgorithm)), Function.identity()));
        for (OCTETSTRING os : crlHashIndex) {
            if (this.isAvailable(os, availableCrls, availableOCSPResponses, availableBasicOCSPResponses)) continue;
            return false;
        }
        return true;
    }

    private boolean isAvailable(OCTETSTRING os, Map<ByteArrayKey, byte[]> availableCrls, Map<ByteArrayKey, byte[]> availableOCSPResponses, Map<ByteArrayKey, byte[]> availableBasicOCSPResponses) {
        byte[] octets = os.getOctets();
        byte[] val = availableCrls.get(new ByteArrayKey(octets));
        if (val != null) {
            return true;
        }
        val = availableOCSPResponses.get(new ByteArrayKey(octets));
        if (val != null) {
            return true;
        }
        val = availableBasicOCSPResponses.get(new ByteArrayKey(octets));
        return val != null;
    }

    static {
        try {
            BASIC_OCSP_RESP_OID = new OBJECTIDENTIFIER(Run.create((Source)new BSource(new ASN1ObjectIdentifier("1.3.6.1.5.5.7.48.1.1").getEncoded())));
            OCSP_RESP_OID = new OBJECTIDENTIFIER(Run.create((Source)new BSource(new ASN1ObjectIdentifier("1.3.6.1.5.5.7.16.2").getEncoded())));
        }
        catch (ParseException | IOException e) {
            LOGGER.warn("Can't create oids. This may cause further problems", e);
        }
    }
}

