/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cades;

import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.AlgorithmIdentifier;
import de.bos_bremen.ci.asn1.OBJECTIDENTIFIER;
import de.bos_bremen.ci.asn1.cms.AtsHashIndex;
import de.bos_bremen.ci.asn1.cms.CMSVersion;
import de.bos_bremen.ci.asn1.cms.SignatureValue;
import de.bos_bremen.ci.asn1.cms.SignedAttributes;
import de.bos_bremen.ci.asn1.cms.SignerIdentifier;
import de.governikus.csl.uom.StreamProvider;
import de.governikus.csl.utils.DigestUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CadesArchiveTimestampMessageDigest
implements StreamProvider {
    OBJECTIDENTIFIER contentType;
    StreamProvider signedContent;
    CMSVersion version;
    SignerIdentifier sid;
    AlgorithmIdentifier digestAlgorithm;
    SignedAttributes signedAttributes;
    AlgorithmIdentifier signatureAlgorithm;
    SignatureValue signature;
    AtsHashIndex atsHashIndex;
    private DigestAlgorithm imprintAlgorithm;

    public CadesArchiveTimestampMessageDigest(OBJECTIDENTIFIER contentType, StreamProvider signedContent, CMSVersion version, SignerIdentifier sid, AlgorithmIdentifier digestAlgorithm, SignedAttributes signedAttributes, AlgorithmIdentifier signatureAlgorithm, SignatureValue signature, AtsHashIndex atsHashIndex, DigestAlgorithm imprintAlgorithm) {
        this.contentType = contentType;
        this.signedContent = signedContent;
        this.version = version;
        this.sid = sid;
        this.digestAlgorithm = digestAlgorithm;
        this.signedAttributes = signedAttributes;
        this.signatureAlgorithm = signatureAlgorithm;
        this.signature = signature;
        this.atsHashIndex = atsHashIndex;
        this.imprintAlgorithm = imprintAlgorithm;
    }

    public InputStream getInputStream() throws IOException {
        return new CadesArchiveTimestampMessageDigestStream();
    }

    private class CadesArchiveTimestampMessageDigestStream
    extends InputStream {
        private int nextDelegate;
        private InputStream currentDelegate;

        private CadesArchiveTimestampMessageDigestStream() {
        }

        @Override
        public int read() throws IOException {
            if (this.currentDelegate == null) {
                this.getNextDelegate();
            }
            if (this.currentDelegate == null) {
                return -1;
            }
            int read = this.currentDelegate.read();
            if (read < 0) {
                this.getNextDelegate();
            }
            return read;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.currentDelegate == null) {
                this.getNextDelegate();
            }
            if (this.currentDelegate == null) {
                return -1;
            }
            int totalRead = 0;
            int toRead = len;
            while (toRead > 0) {
                if (this.currentDelegate == null) {
                    return totalRead;
                }
                int read = this.currentDelegate.read(b, off + totalRead, toRead);
                if (read < toRead) {
                    this.getNextDelegate();
                }
                if (read < 0) continue;
                totalRead += read;
                toRead -= read;
            }
            return totalRead;
        }

        private void getNextDelegate() throws IOException {
            if (this.currentDelegate != null) {
                this.currentDelegate.close();
            }
            if (this.nextDelegate == 0) {
                this.currentDelegate = new ByteArrayInputStream(CadesArchiveTimestampMessageDigest.this.contentType.getEncoded());
            } else if (this.nextDelegate == 1) {
                byte[] hash = DigestUtil.createHashQuietly((StreamProvider)CadesArchiveTimestampMessageDigest.this.signedContent, (DigestAlgorithm)CadesArchiveTimestampMessageDigest.this.imprintAlgorithm);
                this.currentDelegate = new ByteArrayInputStream(hash);
            } else if (this.nextDelegate == 2) {
                this.currentDelegate = new ByteArrayInputStream(CadesArchiveTimestampMessageDigest.this.version.getEncoded());
            } else if (this.nextDelegate == 3) {
                ANY value = (ANY)CadesArchiveTimestampMessageDigest.this.sid;
                this.currentDelegate = new ByteArrayInputStream(value.getEncoded());
            } else {
                this.currentDelegate = this.nextDelegate == 4 ? new ByteArrayInputStream(CadesArchiveTimestampMessageDigest.this.digestAlgorithm.getEncoded()) : (this.nextDelegate == 5 ? new ByteArrayInputStream(CadesArchiveTimestampMessageDigest.this.signedAttributes.getEncoded()) : (this.nextDelegate == 6 ? new ByteArrayInputStream(CadesArchiveTimestampMessageDigest.this.signatureAlgorithm.getEncoded()) : (this.nextDelegate == 7 ? new ByteArrayInputStream(CadesArchiveTimestampMessageDigest.this.signature.getEncoded()) : (this.nextDelegate == 8 ? new ByteArrayInputStream(CadesArchiveTimestampMessageDigest.this.atsHashIndex.getEncoded()) : null))));
            }
            ++this.nextDelegate;
        }

        @Override
        public void close() throws IOException {
            if (this.currentDelegate != null) {
                this.currentDelegate.close();
            }
            super.close();
        }
    }
}

