/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cades;

import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.bos_bremen.ci.asn1.AlgorithmIdentifier;
import de.bos_bremen.ci.asn1.cms.OtherCertID;
import de.bos_bremen.ci.asn1.cms.OtherHashAlgAndValue;
import de.bos_bremen.ci.asn1.esf.OtherHash;
import de.bos_bremen.ci.asn1.tsp.Hash;
import de.bos_bremen.ci.asn1.x509.IssuerSerial;
import de.governikus.csl.uom.validate.commons.AlgorithmManager;
import de.governikus.csl.uom.validate.commons.CertificateReference;
import de.governikus.csl.validation.CertificateReferenceImpl;
import java.math.BigInteger;

public class CAdESUtil {
    public static CertificateReference createCertificateReference(OtherCertID certRef, AlgorithmManager algorithmManager) {
        IssuerSerial issuer = certRef.getIssuerSerial();
        String issuerName = null;
        BigInteger issuerSerial = null;
        if (issuer != null) {
            issuerName = issuer.getName().getName();
            issuerSerial = issuer.getSerialnumber().getValue();
        }
        OtherHash hash = certRef.getOtherCertHash();
        DigestAlgorithm digestAlgorithm = null;
        byte[] data = null;
        if (hash != null) {
            Hash sha1Hash = hash.getSha1Hash();
            OtherHashAlgAndValue otherHash = hash.getOtherHash();
            if (sha1Hash != null) {
                data = sha1Hash.getOctets();
                digestAlgorithm = algorithmManager.getDigestAlgorithmByJcaOidOrUrl("SHA-1", "1.3.14.3.2.26", "http://www.w3.org/2000/09/xmldsig#sha1");
            } else if (otherHash != null) {
                data = otherHash.getHashValue().getOctets();
                AlgorithmIdentifier algorithm = otherHash.getHashAlgorithm();
                digestAlgorithm = algorithmManager.getDigestAlgorithmByJcaOidOrUrl(algorithm.getJCAName(), algorithm.getOID().getOID(), null);
            }
        }
        return new CertificateReferenceImpl(digestAlgorithm, data, issuerName, issuerSerial, null);
    }
}

