/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cades;

import de.bos_bremen.ci.asn1.ParseException;
import de.governikus.csl.cades.CAdESDataExtractor;
import de.governikus.csl.cades.CAdESDocument;
import de.governikus.csl.cades.CAdESParser;
import de.governikus.csl.cades.CMSSignature;
import de.governikus.csl.cades.criteria.CheckCAdESCTimestamps;
import de.governikus.csl.cades.criteria.CheckCertCRLTimestamps;
import de.governikus.csl.cades.criteria.CheckSignerInfoIssues;
import de.governikus.csl.uom.Plugin;
import de.governikus.csl.uom.PluginType;
import de.governikus.csl.uom.SignedData;
import de.governikus.csl.uom.util.TempDataManager;
import de.governikus.csl.uom.validate.commons.ObjectToValidate;
import de.governikus.csl.utils.MagicBytes;
import de.governikus.csl.validate.svp.CAdESSignatureValidationResult;
import de.governikus.csl.validate.svp.ObjectValidationResult;
import de.governikus.csl.validation.AbstractDocumentPlugin;
import de.governikus.csl.validation.ValidatePlugin;
import de.governikus.csl.validation.ValidatePluginException;
import de.governikus.csl.validation.ValidationCriterion;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.criteria.CheckCounterSignatures;
import de.governikus.csl.validation.criteria.CheckSigningCertificateReferences;
import de.governikus.csl.validation.dataExtractor.DataExtractor;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import java.io.IOException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;

@PluginType(id=Plugin.PluginID.VALIDATE_CADES, type=ValidatePlugin.class)
public class CAdESPlugin
extends AbstractDocumentPlugin<CAdESDocument, CMSSignature, ObjectValidationResult, CAdESSignatureValidationResult, SignatureValidationContext> {
    public CAdESPlugin() {
        super(CMSSignature.class, SignatureValidationContext.class);
        this.supportedMimeTypes.add("application/X-CMS");
    }

    public CAdESDocument parseDocument(SignedData doc, TempDataManager tempDataManager) throws ValidatePluginException {
        try {
            CAdESParser dl = new CAdESParser(this.configuration.getAlgorithmManager(), tempDataManager);
            return dl.loadDocument(doc);
        }
        catch (ParseException | IOException | NoSuchProviderException | CertificateException e) {
            throw new ValidatePluginException((ValidatePlugin)this, "Can't parse document", e);
        }
    }

    protected ObjectValidationResult createResultStructure(ObjectToValidate<?> objectToValidate) {
        ObjectValidationResult ovr = new ObjectValidationResult();
        ovr.setObjectTypeID(Plugin.PluginID.VALIDATE_CADES.getID());
        return ovr;
    }

    protected CAdESSignatureValidationResult createSignatureValidationResultStructure() {
        return new CAdESSignatureValidationResult();
    }

    public SignatureValidationContext createContext(CMSSignature signature, ValidationPolicyType policy) {
        return new SignatureValidationContext(policy);
    }

    public MagicBytes getMagicBytesOfDocumentFormat() {
        return MagicBytes.MAGIC_BYTES_CMS;
    }

    public static List<ValidationCriterion<? super CMSSignature, ? super CAdESSignatureValidationResult, ? super SignatureValidationContext>> getAllKnownCustomPlugins() {
        ArrayList<ValidationCriterion<? super CMSSignature, ? super CAdESSignatureValidationResult, ? super SignatureValidationContext>> result = new ArrayList<ValidationCriterion<? super CMSSignature, ? super CAdESSignatureValidationResult, ? super SignatureValidationContext>>();
        result.add((ValidationCriterion<? super CMSSignature, ? super CAdESSignatureValidationResult, ? super SignatureValidationContext>)new CheckSignerInfoIssues());
        result.add((ValidationCriterion<? super CMSSignature, ? super CAdESSignatureValidationResult, ? super SignatureValidationContext>)new CheckCAdESCTimestamps());
        result.add((ValidationCriterion<? super CMSSignature, ? super CAdESSignatureValidationResult, ? super SignatureValidationContext>)new CheckCertCRLTimestamps());
        result.add((ValidationCriterion<? super CMSSignature, ? super CAdESSignatureValidationResult, ? super SignatureValidationContext>)new CheckCounterSignatures());
        result.add((ValidationCriterion<? super CMSSignature, ? super CAdESSignatureValidationResult, ? super SignatureValidationContext>)new CheckSigningCertificateReferences());
        return result;
    }

    public DataExtractor<? super CMSSignature, ? super CAdESSignatureValidationResult> getSignatureDataExtractor() {
        return new CAdESDataExtractor();
    }
}

