/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cades;

import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.bos_bremen.algorithm_identifier.SignatureAlgorithm;
import de.bos_bremen.ci.SSource;
import de.bos_bremen.ci.Source;
import de.bos_bremen.ci.StreamableInputData;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.AlgorithmIdentifier;
import de.bos_bremen.ci.asn1.OBJECTIDENTIFIER;
import de.bos_bremen.ci.asn1.OCTETSTRING;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.Time;
import de.bos_bremen.ci.asn1.cms.AtsHashIndex;
import de.bos_bremen.ci.asn1.cms.CMSSignedData;
import de.bos_bremen.ci.asn1.cms.CertificateSet;
import de.bos_bremen.ci.asn1.cms.CertificateValues;
import de.bos_bremen.ci.asn1.cms.CertifiedAttributesV2;
import de.bos_bremen.ci.asn1.cms.CompleteCertificateRefs;
import de.bos_bremen.ci.asn1.cms.ContentType;
import de.bos_bremen.ci.asn1.cms.EncapsulatedContentInfo;
import de.bos_bremen.ci.asn1.cms.OtherCertID;
import de.bos_bremen.ci.asn1.cms.SignedAttribute;
import de.bos_bremen.ci.asn1.cms.SignedAttributes;
import de.bos_bremen.ci.asn1.cms.SignerAttribute;
import de.bos_bremen.ci.asn1.cms.SignerAttributeV2;
import de.bos_bremen.ci.asn1.cms.SignerInfo;
import de.bos_bremen.ci.asn1.cms.UnsignedAttributes;
import de.bos_bremen.ci.asn1.crl.CertificateList;
import de.bos_bremen.ci.asn1.crl.OtherRevocationInfoFormat;
import de.bos_bremen.ci.asn1.crl.RevocationInfoChoice;
import de.bos_bremen.ci.asn1.crl.RevocationInfoChoices;
import de.bos_bremen.ci.asn1.er.EvidenceRecord;
import de.bos_bremen.ci.asn1.ocsp.BasicOCSPResponse;
import de.bos_bremen.ci.asn1.ocsp.OCSPResponse;
import de.bos_bremen.ci.asn1.ocsp.RevocationValues;
import de.bos_bremen.ci.asn1.tsp.ESSCertID;
import de.bos_bremen.ci.asn1.tsp.SignatureTimeStampToken;
import de.bos_bremen.ci.asn1.tsp.SigningCertificate;
import de.bos_bremen.ci.asn1.tsp.TSTInfo;
import de.bos_bremen.ci.asn1.tsp.TimeStampToken;
import de.bos_bremen.ci.asn1.x509.Attribute;
import de.bos_bremen.ci.asn1.x509.AttributeCertificate;
import de.bos_bremen.ci.asn1.x509.Certificate;
import de.bos_bremen.ci.asn1.x509.FlatCertificate;
import de.governikus.csl.cades.CAdESArchiveTimestamp;
import de.governikus.csl.cades.CAdESDocument;
import de.governikus.csl.cades.CAdESUtil;
import de.governikus.csl.cades.CAdESValidationData;
import de.governikus.csl.cades.CMSSignature;
import de.governikus.csl.cades.CadesArchiveTimestampMessageDigest;
import de.governikus.csl.cades.OCTETSTRINGDocument;
import de.governikus.csl.cades.SignerInfoIssue;
import de.governikus.csl.cades.attributes.SignatureAttributesGenerator;
import de.governikus.csl.core.impl.BaseSignature;
import de.governikus.csl.core.impl.BaseSignedContentPart;
import de.governikus.csl.core.impl.DetachedSignedData;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.SignedData;
import de.governikus.csl.uom.StreamProvider;
import de.governikus.csl.uom.docs.ByteArrayDocument;
import de.governikus.csl.uom.impl.ByteArrayStreamProvider;
import de.governikus.csl.uom.impl.FileDocumentImpl;
import de.governikus.csl.uom.impl.FileStreamProvider;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.sign.SignatureType;
import de.governikus.csl.uom.util.ConcatenatedDocumentInputStreamProvider;
import de.governikus.csl.uom.util.TempDataManager;
import de.governikus.csl.uom.validate.DateType;
import de.governikus.csl.uom.validate.commons.AlgorithmManager;
import de.governikus.csl.uom.validate.commons.CertificateReference;
import de.governikus.csl.uom.validate.commons.SignatureValidationDataAttachment;
import de.governikus.csl.uom.validate.commons.SignedContentPart;
import de.governikus.csl.uom.validate.commons.WritableSignature;
import de.governikus.csl.uom.validate.commons.WritableTimestamp;
import de.governikus.csl.utils.AbstractDocumentParser;
import de.governikus.csl.utils.CryptoProviderUtil;
import de.governikus.csl.validate.svp.SignatureAttributesType;
import de.governikus.csl.validation.ASN1Util;
import de.governikus.csl.validation.er.EvidenceRecordCreator;
import de.governikus.csl.validation.er.EvidenceRecordFilter;
import de.governikus.csl.validation.er.EvidenceRecordFilterResult;
import de.governikus.csl.validation.tsp.DefaultTimestampFactory;
import de.governikus.csl.validation.tsp.TSPParser;
import de.governikus.csl.validation.tsp.TimestampFactory;
import de.governikus.csl.validation.tsp.TimestampedObject;
import de.governikus.csl.vi.StreamableCSLDocument;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.ocsp.OCSPResponseStatus;
import org.bouncycastle.asn1.ocsp.ResponseBytes;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cms.CMSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAdESParser
extends AbstractDocumentParser<CAdESDocument> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CAdESParser.class);
    private CertificateFactory certFactory = CryptoProviderUtil.getCertificateFactoryInstance((String)"X509");
    private CMSSignedData cms;
    private SignedData sda;
    private SignatureType signatureType;
    private de.bos_bremen.ci.asn1.cms.SignedData signedData;
    private EncapsulatedContentInfo contentInfo;
    private Set<SignatureValidationDataAttachment<X509Certificate>> attachedCertificates;
    private List<SignatureValidationDataAttachment<CRL>> attachedCRLs;
    private List<SignatureValidationDataAttachment<OCSPResp>> attachedOCSPs;
    private CertificateSet certSet;
    private CAdESDocument result;
    private AlgorithmManager algorithmManager;
    private List<Document> includedFiles;
    private Document doc;
    private StreamProvider signedContentData;
    private TempDataManager tempDataManger;

    public CAdESParser(AlgorithmManager algorithmManager, TempDataManager tempDataManger) throws CertificateException, NoSuchProviderException {
        this.tempDataManger = tempDataManger;
        this.algorithmManager = algorithmManager;
    }

    public CAdESDocument loadDocument(SignedData sda) throws IOException, ParseException {
        this.sda = sda;
        this.doc = sda.getSignature();
        SSource sSource = new SSource((StreamableInputData)new StreamableCSLDocument(this.doc));
        this.result = new CAdESDocument();
        this.result.setName(this.doc.getName());
        CMSSignedData cmsSignedData = new CMSSignedData((Source)sSource);
        this.loadDocument(cmsSignedData);
        return this.result;
    }

    public CAdESDocument loadDocument(CMSSignedData cms) throws ParseException {
        if (this.result == null) {
            this.result = new CAdESDocument();
        }
        this.cms = cms;
        this.signedData = cms.getSignedData();
        if (this.signedData == null) {
            throw new ParseException("No SignedData found");
        }
        this.processSignedData();
        return this.result;
    }

    private void processSignedData() throws ParseException {
        RevocationInfoChoices revocationValues;
        this.contentInfo = this.signedData.getEncapsulatedContentInfo();
        if (ContentType.id_ct_TSTInfo.equals((Object)this.contentInfo.getContentType())) {
            throw new ParseException("The given data seems to be a timestamp. This parser is not intended for parsing timestamps");
        }
        this.certSet = this.signedData.getCertificates();
        if (this.certSet != null) {
            for (FlatCertificate fc : this.certSet.getCertificateChoices()) {
                this.addAttachedCertificate(fc);
            }
        }
        if ((revocationValues = this.signedData.getCRLs()) != null) {
            this.processGlobalRevocationValues(revocationValues);
        }
        List<CMSSignature> signatures = this.processSignerInfos();
        this.result.setSignatures(signatures);
    }

    private void processGlobalRevocationValues(RevocationInfoChoices revocationValues) {
        for (RevocationInfoChoice next : revocationValues) {
            if (next instanceof CertificateList) {
                this.addCRLValue((CertificateList)next);
                continue;
            }
            if (!(next instanceof OtherRevocationInfoFormat)) continue;
            OtherRevocationInfoFormat revValue = (OtherRevocationInfoFormat)next;
            OBJECTIDENTIFIER format = revValue.getOtherRevInfoFormat();
            String oid = format.getOID();
            ANY otherRevInfo = revValue.getOtherRevInfo();
            if (oid.equals("1.3.6.1.5.5.7.16.2") && otherRevInfo instanceof OCSPResponse) {
                OCSPResponse resp = (OCSPResponse)otherRevInfo;
                try {
                    this.addAttachedOCSPResp(new OCSPResp(resp.getEncoded()));
                }
                catch (IOException e) {
                    LOGGER.error("Couldn't create OCSPResp", (Throwable)e);
                }
                continue;
            }
            if (!oid.equals("1.3.6.1.5.5.7.48.1.1") || !(otherRevInfo instanceof BasicOCSPResponse)) continue;
            BasicOCSPResponse basicOCSPResp = (BasicOCSPResponse)otherRevInfo;
            this.addAttachedBasicOCSPResp(basicOCSPResp);
        }
    }

    private void addCRLValue(CertificateList cl) {
        try {
            CRL crl = this.certFactory.generateCRL(new ByteArrayInputStream(cl.getEncoded()));
            if (this.attachedCRLs == null) {
                this.attachedCRLs = new ArrayList<SignatureValidationDataAttachment<CRL>>();
            }
            this.attachedCRLs.add((SignatureValidationDataAttachment<CRL>)new CAdESValidationData<CRL>(crl));
        }
        catch (CRLException e) {
            LOGGER.error("Couldn't create CRL", (Throwable)e);
        }
    }

    private void addAttachedCertificate(FlatCertificate fc) {
        try {
            X509Certificate cert = (X509Certificate)this.certFactory.generateCertificate(new ByteArrayInputStream(fc.getEncoded()));
            if (this.attachedCertificates == null) {
                this.attachedCertificates = new HashSet<SignatureValidationDataAttachment<X509Certificate>>();
            }
            this.attachedCertificates.add((SignatureValidationDataAttachment<X509Certificate>)new CAdESValidationData<X509Certificate>(cert));
        }
        catch (CertificateException e) {
            LOGGER.error("Couldn't parse certificate", (Throwable)e);
        }
    }

    private List<CMSSignature> processSignerInfos() {
        List signerInfos = this.signedData.getSignerInfoList();
        ArrayList<CMSSignature> signatures = new ArrayList<CMSSignature>();
        for (SignerInfo si : signerInfos) {
            CMSSignature signature = this.processSignerInfo(si, null);
            signature.setSignedData(this.signedData);
            signature.setAttachedCertificates(this.attachedCertificates);
            signature.setAttachedCRLs(this.attachedCRLs);
            signature.setAttachedOCSPValues(this.attachedOCSPs);
            signature.setRawData(this.cms);
            signatures.add(signature);
        }
        return signatures;
    }

    private CMSSignature processSignerInfo(SignerInfo si, CMSSignature parent) {
        UnsignedAttributes unsignedAttributes;
        SignedAttributes signedAttributes;
        List certs;
        CMSSignature signature = new CMSSignature();
        try {
            AlgorithmIdentifier signatureAlgorithm = si.getSignatureAlgorithm();
            String algorithmOID = signatureAlgorithm.getOID().getOID();
            if (algorithmOID == null || algorithmOID.trim().isEmpty()) {
                signature.getSignerInfoIssueList().add(SignerInfoIssue.MISSING_SIGNATURE_ALGORITHM_OID);
                LOGGER.error("Couldn't find the signature algorithm OID");
            }
            signature.setSignatureAlgorithmName(signatureAlgorithm.getJCAName());
            signature.setSignatureAlgorithmOID(algorithmOID);
            SignatureAlgorithm sigAlgorithm = this.algorithmManager.getSignatureAlgorithmByJcaOidOrUrl(signatureAlgorithm.getJCAName(), algorithmOID, null);
            signature.setSignatureAlgorithm(sigAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            signature.getSignerInfoIssueList().add(SignerInfoIssue.UNKNOWN_SIGNATURE_ALGORITHM);
            LOGGER.error("Couldn't determine signature algorithm", (Throwable)e);
        }
        catch (ParseException e) {
            signature.getSignerInfoIssueList().add(SignerInfoIssue.PARSE_ERROR);
            LOGGER.error("Couldn't parse the signature algorithm identifier ASN.1 structure", (Throwable)e);
        }
        signature.setSignatureValue(si.getSignature().getOctets());
        Date signingTime = CAdESParser.getSigningTime(this.contentInfo, si);
        if (signingTime != null) {
            signature.setSigningTime(SVPFactory.createTypedDate((Date)signingTime, (DateType)DateType.CLAIMED_SIGNING_TIME));
        }
        this.calculateSignedContentParts(si, signature, parent);
        if (this.certSet != null && !(certs = this.certSet.getMatchingCertificates(si.getSid())).isEmpty()) {
            FlatCertificate flatCert = (FlatCertificate)certs.get(0);
            try {
                X509Certificate cert = (X509Certificate)this.certFactory.generateCertificate(new ByteArrayInputStream(flatCert.getEncoded()));
                signature.setSigningCertificate(new X509CertificateImpl(cert));
            }
            catch (CertificateException e) {
                signature.getSignerInfoIssueList().add(SignerInfoIssue.CANNOT_RECREATE_SIGNING_CERTIFICATE);
                LOGGER.error("Couldn't recreate signing certificate", (Throwable)e);
            }
        }
        if (signature.getSigningCertificate() == null) {
            signature.getSignerInfoIssueList().add(SignerInfoIssue.NO_MATCHING_SIGNING_CERTIFICATE);
            LOGGER.error("Couldn't determine signing certificate");
        }
        if ((signedAttributes = si.getSignedAttributes()) != null) {
            this.processSignedAttributes(signedAttributes, signature);
        }
        if ((unsignedAttributes = si.getUnsignedAttributes()) != null) {
            this.processUnsignedAttributes(si, unsignedAttributes, signature);
        }
        if (signature.getSigningCertificate() == null) {
            this.determineSigningCertificateFromReferences(signature);
        }
        return signature;
    }

    private void determineSigningCertificateFromReferences(CMSSignature signature) {
        List signingCertificateRefs = signature.getSigningCertificateReferences();
        if (signingCertificateRefs == null || signingCertificateRefs.isEmpty()) {
            LOGGER.error("Couldn't find signing certificate reference");
            return;
        }
        CertificateReference ref = (CertificateReference)signingCertificateRefs.get(0);
        if (this.attachedCertificates == null) {
            LOGGER.error("Couldn't find signing certificate");
            return;
        }
        for (SignatureValidationDataAttachment<X509Certificate> cert : this.attachedCertificates) {
            X509Certificate value = (X509Certificate)cert.getValue();
            if (!ref.isReferenced((java.security.cert.Certificate)value)) continue;
            signature.setSigningCertificate(new X509CertificateImpl(value));
            return;
        }
        LOGGER.error("Couldn't find signing certificate");
    }

    private void processSignedAttributes(SignedAttributes signedAttributes, CMSSignature signature) {
        List<TimestampedObject> contentTimestamps;
        List certIDs;
        byte[] bytes = signedAttributes.asByteArray();
        if (bytes.length > 0 && signedAttributes.isImplicit()) {
            bytes[0] = 49;
        }
        signature.setSignedContent((Document)new ByteArrayDocument(bytes));
        SigningCertificate signingCertificate = (SigningCertificate)signedAttributes.getValue(SignedAttribute.SIGNING_CERTIFICATE_V2);
        if (signingCertificate == null) {
            signingCertificate = (SigningCertificate)signedAttributes.getValue(SignedAttribute.signingCertificate);
        }
        ArrayList<CertificateReference> references = null;
        if (signingCertificate != null && (certIDs = signingCertificate.getCertIDs()) != null) {
            for (Object certID : certIDs) {
                CertificateReference ref = ASN1Util.createCertificateReference((ESSCertID)certID, (AlgorithmManager)this.algorithmManager);
                if (ref == null) continue;
                if (references == null) {
                    references = new ArrayList<CertificateReference>();
                }
                references.add(ref);
            }
        }
        signature.setSigningCertificateReferences(references);
        TimeStampToken contentTS = (TimeStampToken)signedAttributes.getValue(Attribute.CONTENT_TIME_STAMP);
        if (contentTS != null && (contentTimestamps = this.parseTimestamp(contentTS)) != null && !contentTimestamps.isEmpty()) {
            for (TimestampedObject to : contentTimestamps) {
                StreamProvider content = this.getSignedContent(null);
                to.setTimestampedContent(content);
            }
            signature.setSignedDataTimestamps(contentTimestamps);
        }
        OBJECTIDENTIFIER contentType = (OBJECTIDENTIFIER)signedAttributes.getValue(SignedAttribute.contentType);
        signature.setContentType(contentType);
        OCTETSTRING messageDigest = (OCTETSTRING)signedAttributes.getValue(SignedAttribute.messageDigest);
        if (messageDigest != null) {
            signature.setMessageDigest(messageDigest.getOctets());
        }
        CAdESParser.addAttributeCertificates(signature, signedAttributes.getValues(SignedAttribute.attributeCertificate));
        CAdESParser.addNewAttributeCertificates(signature, signedAttributes.getValues(OBJECTIDENTIFIER.valueOf((String)PKCSObjectIdentifiers.id_aa_ets_signerAttr.getId())));
        this.addENAttributeCertificates(signature, signedAttributes.getValues(SignedAttribute.SIGNER_ATTRIBUTES_V2));
        SignatureAttributesType sigAtters = SignatureAttributesGenerator.createSignatureAttributes(signedAttributes.getAttributes());
        signature.setSignatureAttributes(sigAtters);
    }

    private static void addAttributeCertificates(CMSSignature signature, List<ANY> values) {
        if (values != null) {
            for (ANY a : values) {
                AttributeCertificate ac = (AttributeCertificate)a;
                CAdESParser.addAttributeCertificate(signature, ac);
            }
        }
    }

    private List<TimestampedObject> parseTimestamp(TimeStampToken tsp) {
        return this.parseTimestamps(tsp, (TimestampFactory)new DefaultTimestampFactory());
    }

    private <T extends WritableTimestamp<S>, S extends WritableSignature> List<T> parseTimestamps(TimeStampToken tsp, TimestampFactory<T, S> factory) {
        TSPParser parser = new TSPParser(this.algorithmManager);
        return parser.parse((de.bos_bremen.ci.asn1.cms.SignedData)tsp.getContent(), null, factory);
    }

    private void processUnsignedAttributes(SignerInfo si, UnsignedAttributes unsignedAttributes, CMSSignature signature) {
        List counterSignatures = unsignedAttributes.getValues(Attribute.COUNTER_SIGNATURE);
        if (counterSignatures != null) {
            ArrayList<CMSSignature> counterSignaturesList = new ArrayList<CMSSignature>();
            for (ANY counterSignature : counterSignatures) {
                CMSSignature cs = this.processSignerInfo((SignerInfo)counterSignature, signature);
                counterSignaturesList.add(cs);
            }
            if (!counterSignaturesList.isEmpty()) {
                signature.setCounterSignatures(Collections.unmodifiableList(counterSignaturesList));
            }
        }
        List refs = unsignedAttributes.getValues(Attribute.CERTIFICATE_REFS);
        this.processCompleteCertificateRefs(signature, refs);
        List certValues = unsignedAttributes.getValues(Attribute.CERT_VALUES);
        this.processCertificateValues(certValues);
        List revocationValues = unsignedAttributes.getValues(Attribute.REVOCATION_VALUES);
        this.processRevocationValues(revocationValues);
        List timestampToken = unsignedAttributes.getValues(ContentType.id_aa_timeStampToken);
        List<TimestampedObject> timestamps = null;
        if (timestampToken != null) {
            for (ANY a : timestampToken) {
                if (!(a instanceof TimeStampToken)) continue;
                TimeStampToken tst = (TimeStampToken)a;
                List<TimestampedObject> tmpTimestamps = this.parseTimestamp(tst);
                for (TimestampedObject to : tmpTimestamps) {
                    ByteArrayStreamProvider bais = new ByteArrayStreamProvider(signature.getSignatureValue());
                    to.setTimestampedContent((StreamProvider)bais);
                    to.setAttachedCertificates(this.attachedCertificates);
                    to.setAttachedCRLs(this.attachedCRLs);
                    to.setAttachedOCSPValues(this.attachedOCSPs);
                }
                if (timestamps == null) {
                    timestamps = tmpTimestamps;
                    continue;
                }
                timestamps.addAll(tmpTimestamps);
            }
        }
        signature.setSignatureTimestamps(timestamps);
        List cadesCTimestamps = unsignedAttributes.getValues(Attribute.ESC_TIMESTAMP_TOKEN);
        this.processCAdES_C_Timestamps(si, unsignedAttributes, signature, cadesCTimestamps);
        List certTimestamps = unsignedAttributes.getValues(Attribute.CERTCRLTIMESTAMP);
        this.processCertCRLTimestamps(unsignedAttributes, signature, certTimestamps);
        List<CAdESArchiveTimestamp> archiveTimestamps = this.processArchiveTimestamps(unsignedAttributes, si);
        if (archiveTimestamps != null) {
            archiveTimestamps.forEach(x -> x.setSignature(signature));
            signature.setArchiveTimestamps(archiveTimestamps);
        }
        signature.setEvidenceRecords(this.processEvidenceRecords(unsignedAttributes));
        SignatureAttributesType unsignedSigAttrs = SignatureAttributesGenerator.createSignatureAttributes(unsignedAttributes.getAttributes());
        SignatureAttributesType signatureAttributes = signature.getSignatureAttributes();
        if (signatureAttributes == null) {
            signature.setSignatureAttributes(unsignedSigAttrs);
        } else {
            List sigAttrs = signatureAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat();
            sigAttrs.addAll(unsignedSigAttrs.getSigningTimeOrSigningCertificateOrDataObjectFormat());
        }
    }

    private List<de.governikus.csl.validation.er.EvidenceRecord> processEvidenceRecords(UnsignedAttributes unsignedAttributes) {
        int numEvidenceRecords;
        List<de.governikus.csl.validation.er.EvidenceRecord> resultList = null;
        List evidenceRecords = unsignedAttributes.getValues(Attribute.ID_AA_ER_EXTERNAL);
        List<de.governikus.csl.validation.er.EvidenceRecord> createdEvidenceRecords = this.createEvidenceRecords(evidenceRecords, numEvidenceRecords = 0, true);
        resultList = createdEvidenceRecords;
        if (resultList != null) {
            numEvidenceRecords += resultList.size();
        }
        if ((createdEvidenceRecords = this.createEvidenceRecords(evidenceRecords = unsignedAttributes.getValues(Attribute.ID_AA_ER_INTERNAL), numEvidenceRecords, false)) != null) {
            if (resultList == null) {
                resultList = createdEvidenceRecords;
            } else {
                resultList.addAll(createdEvidenceRecords);
            }
        }
        return resultList;
    }

    private List<CAdESArchiveTimestamp> processArchiveTimestamps(UnsignedAttributes attributes, SignerInfo si) {
        BiConsumer consumer = (x, y) -> y.addAll(this.parseArchiveTimestamp((SignedAttribute)x, si));
        List<CAdESArchiveTimestamp> resultList = null;
        Map attributes2 = attributes.getAttributes();
        List atst = (List)attributes2.get(Attribute.ARCHIVE_TIMESTAMP_V1);
        resultList = this.processAnyList(atst, resultList, consumer);
        atst = (List)attributes2.get(Attribute.ARCHIVE_TIMESTAMP_V2);
        resultList = this.processAnyList(atst, resultList, consumer);
        atst = (List)attributes2.get(Attribute.ARCHIVE_TIMESTAMP_V3);
        resultList = this.processAnyList(atst, resultList, consumer);
        return resultList;
    }

    private List<CAdESArchiveTimestamp> parseArchiveTimestamp(SignedAttribute sa, SignerInfo si) {
        List values = sa.getValues();
        ArrayList<CAdESArchiveTimestamp> timestamps = new ArrayList<CAdESArchiveTimestamp>();
        for (ANY a : values) {
            List<CAdESArchiveTimestamp> parseArchiveTimestamp = this.parseTimestamps((TimeStampToken)a, new CAdESArchiveTimestampFactory(sa, a));
            timestamps.addAll(parseArchiveTimestamp);
        }
        OBJECTIDENTIFIER contentType = this.signedData.getEncapsulatedContentInfo().getContentType();
        for (CAdESArchiveTimestamp timestamp : timestamps) {
            timestamp.setAttachedCertificates(this.attachedCertificates);
            timestamp.setAttachedCRLs(this.attachedCRLs);
            timestamp.setAttachedOCSPValues(this.attachedOCSPs);
            List atsHashIndizes = timestamp.getAtsHashIndizes();
            AtsHashIndex atsHashIndex = null;
            if (atsHashIndizes != null && !atsHashIndizes.isEmpty()) {
                atsHashIndex = (AtsHashIndex)atsHashIndizes.get(0);
            }
            timestamp.setTimestampedContent(new CadesArchiveTimestampMessageDigest(contentType, this.getSignedContent(null), si.getVersion(), si.getSid(), si.getDigestAlgorithm(), si.getSignedAttributes(), si.getDigestEncryptionAlgorithm(), si.getSignature(), atsHashIndex, timestamp.getMessageImprintHashAlgorithm()));
        }
        return timestamps;
    }

    public List<de.governikus.csl.validation.er.EvidenceRecord> createEvidenceRecords(List<ANY> evidenceRecords, int numEvidenceRecords, boolean external) {
        if (evidenceRecords == null || evidenceRecords.isEmpty()) {
            return null;
        }
        EvidenceRecordCreator creator = new EvidenceRecordCreator(this.algorithmManager);
        ArrayList<de.governikus.csl.validation.er.EvidenceRecord> resultList = new ArrayList<de.governikus.csl.validation.er.EvidenceRecord>();
        byte[] encoded = null;
        try (InputStream is = this.doc.getInputStream();){
            encoded = IOUtils.toByteArray((InputStream)is);
        }
        catch (IOException e1) {
            LOGGER.warn("Can't read signature", (Throwable)e1);
            return null;
        }
        for (ANY any : evidenceRecords) {
            de.governikus.csl.validation.er.EvidenceRecord er = creator.create((EvidenceRecord)any);
            EvidenceRecordFilter filter = new EvidenceRecordFilter(encoded, numEvidenceRecords++);
            try {
                List contents;
                EvidenceRecordFilterResult filterEvidenceRecords = filter.filterEvidenceRecords();
                ArrayList<ByteArrayDocument> expectedValues = new ArrayList<ByteArrayDocument>();
                expectedValues.add(new ByteArrayDocument(filterEvidenceRecords.getSignature()));
                er.setExpectedSecuredData(expectedValues);
                if (external && (contents = this.sda.getContents()) != null) {
                    expectedValues.addAll(contents);
                }
            }
            catch (IOException | CMSException e) {
                LOGGER.info("");
            }
            resultList.add(er);
        }
        return resultList;
    }

    private <T> List<T> processAnyList(List<SignedAttribute> archiveTimestamps, List<T> currentTimestamps, BiConsumer<SignedAttribute, List<T>> consumer) {
        if (archiveTimestamps == null || archiveTimestamps.isEmpty()) {
            return currentTimestamps;
        }
        if (currentTimestamps == null) {
            currentTimestamps = new ArrayList<T>();
        }
        List result = currentTimestamps;
        archiveTimestamps.forEach(x -> consumer.accept((SignedAttribute)x, result));
        return currentTimestamps;
    }

    private void processCertCRLTimestamps(UnsignedAttributes unsignedAttributes, CMSSignature signature, List<ANY> certTimestamps) {
        byte[] data2;
        if (certTimestamps == null) {
            return;
        }
        Map attributes = unsignedAttributes.getAttributes();
        List tmpList = (List)attributes.get(Attribute.CERTIFICATE_REFS);
        ArrayList<byte[]> dataToTimestamp2 = new ArrayList<byte[]>();
        int length = 0;
        if (tmpList != null) {
            for (Object sa : tmpList) {
                data2 = sa.getValueAsByteArray();
                dataToTimestamp2.add(data2);
                length += data2.length;
            }
        }
        if ((tmpList = (List)attributes.get(Attribute.REVOCATION_REFS)) != null) {
            for (Object sa : tmpList) {
                data2 = sa.getValueAsByteArray();
                dataToTimestamp2.add(data2);
                length += data2.length;
            }
        }
        ByteBuffer bb = ByteBuffer.allocate(length);
        for (byte[] data2 : dataToTimestamp2) {
            bb.put(data2);
        }
        byte[] completeTimestampedData = bb.array();
        ArrayList<TimestampedObject> certCRLTimestamps = new ArrayList<TimestampedObject>();
        for (ANY a : certTimestamps) {
            SignatureTimeStampToken stst = (SignatureTimeStampToken)a;
            List<TimestampedObject> timestamps = this.parseTimestamp((TimeStampToken)stst);
            if (timestamps == null) continue;
            for (TimestampedObject to : timestamps) {
                certCRLTimestamps.add(to);
                to.setTimestampedContent((StreamProvider)new ByteArrayStreamProvider(completeTimestampedData));
            }
        }
        if (!certCRLTimestamps.isEmpty()) {
            signature.setCertCRLTimestamps(certCRLTimestamps);
        }
    }

    private void processCAdES_C_Timestamps(SignerInfo si, UnsignedAttributes unsignedAttributes, CMSSignature signature, List<ANY> cadesCTimestamps) {
        if (cadesCTimestamps == null) {
            return;
        }
        ArrayList<byte[]> timestampedData = new ArrayList<byte[]>();
        int timestampedDataLength = 0;
        byte[] data = si.getSignature().getOctets();
        timestampedData.add(data);
        timestampedDataLength += data.length;
        Map attributes = unsignedAttributes.getAttributes();
        List tmpList = (List)attributes.get(ContentType.id_aa_timeStampToken);
        ArrayList dataToTimestamp2 = new ArrayList();
        if (tmpList != null) {
            dataToTimestamp2.addAll(tmpList);
        }
        if ((tmpList = (List)attributes.get(Attribute.CERTIFICATE_REFS)) != null) {
            dataToTimestamp2.addAll(tmpList);
        }
        if ((tmpList = (List)attributes.get(Attribute.REVOCATION_REFS)) != null) {
            dataToTimestamp2.addAll(tmpList);
        }
        for (Object a : dataToTimestamp2) {
            data = a.getValueAsByteArray();
            timestampedData.add(data);
            timestampedDataLength += data.length;
        }
        ByteBuffer bb = ByteBuffer.allocate(timestampedDataLength);
        for (byte[] d : timestampedData) {
            bb.put(d);
        }
        byte[] completeTimestampedData = bb.array();
        ArrayList<TimestampedObject> cadesCTsps = new ArrayList<TimestampedObject>();
        for (ANY a : cadesCTimestamps) {
            SignatureTimeStampToken stst = (SignatureTimeStampToken)a;
            List<TimestampedObject> timestamps = this.parseTimestamp((TimeStampToken)stst);
            if (timestamps == null) continue;
            for (TimestampedObject to : timestamps) {
                cadesCTsps.add(to);
                to.setTimestampedContent((StreamProvider)new ByteArrayStreamProvider(completeTimestampedData));
            }
        }
        if (!cadesCTsps.isEmpty()) {
            signature.setCadesCTimestamps(cadesCTsps);
        }
    }

    private void processRevocationValues(List<ANY> revocationValues) {
        if (revocationValues == null) {
            return;
        }
        for (ANY a : revocationValues) {
            List ocsps;
            RevocationValues revoValues = (RevocationValues)a;
            List crls = revoValues.getCrlVals();
            if (crls != null) {
                for (CertificateList crl : crls) {
                    this.addCRLValue(crl);
                }
            }
            if ((ocsps = revoValues.getOcspVals()) == null) continue;
            for (BasicOCSPResponse ocsp : ocsps) {
                this.addAttachedBasicOCSPResp(ocsp);
            }
        }
    }

    private void addAttachedBasicOCSPResp(BasicOCSPResponse ocsp) {
        ResponseBytes rb = new ResponseBytes(new ASN1ObjectIdentifier(BasicOCSPResponse.OID_BASIC_OCSP_RESPONSE.getOID()), (ASN1OctetString)new DEROctetString(ocsp.getEncoded()));
        org.bouncycastle.asn1.ocsp.OCSPResponse ocspResp = new org.bouncycastle.asn1.ocsp.OCSPResponse(new OCSPResponseStatus(0), rb);
        OCSPResp resp = new OCSPResp(ocspResp);
        this.addAttachedOCSPResp(resp);
    }

    private void addAttachedOCSPResp(OCSPResp resp) {
        if (this.attachedOCSPs == null) {
            this.attachedOCSPs = new ArrayList<SignatureValidationDataAttachment<OCSPResp>>();
        }
        this.attachedOCSPs.add((SignatureValidationDataAttachment<OCSPResp>)new CAdESValidationData<OCSPResp>(resp));
    }

    private void processCertificateValues(List<ANY> certValues) {
        if (certValues == null) {
            return;
        }
        for (ANY a : certValues) {
            CertificateValues cv = (CertificateValues)a;
            List certificates = cv.getCertificates();
            for (Certificate cert : certificates) {
                this.addAttachedCertificate((FlatCertificate)cert);
            }
        }
    }

    private void processCompleteCertificateRefs(CMSSignature signature, List<ANY> refs) {
        if (refs == null) {
            return;
        }
        ArrayList<CertificateReference> references = new ArrayList<CertificateReference>();
        for (ANY o : refs) {
            CompleteCertificateRefs crefs = (CompleteCertificateRefs)o;
            List certRefs = crefs.getCertRefs();
            if (certRefs == null) continue;
            for (OtherCertID certRef : certRefs) {
                CertificateReference ref = CAdESUtil.createCertificateReference(certRef, this.algorithmManager);
                references.add(ref);
            }
        }
        if (!references.isEmpty()) {
            signature.setCompleteCertificateReferences(references);
        }
    }

    private void calculateSignedContentParts(SignerInfo si, CMSSignature signature, CMSSignature parent) {
        SignedAttributes sa = si.getSignedAttributes();
        if (sa == null) {
            signature.getSignerInfoIssueList().add(SignerInfoIssue.MISSING_CONTENT);
            LOGGER.error("Couldn't find any signed content");
            return;
        }
        OCTETSTRING digestString = (OCTETSTRING)sa.getValue(SignedAttribute.messageDigest);
        byte[] digest = digestString.getOctets();
        StreamProvider contentData = null;
        byte[] hashValue = null;
        if (parent != null) {
            byte[] signatureValue = parent.getSignatureValue();
            contentData = new ByteArrayStreamProvider(signatureValue);
            signature.setSignatureType(SignatureType.ENVELOPED);
        } else if (this.sda != null && this.sda.getHashValues() != null && !this.sda.getHashValues().isEmpty()) {
            hashValue = (byte[])this.sda.getHashValues().get(0);
            signature.setSignatureType(SignatureType.DETACHED);
        } else {
            contentData = this.getSignedContent(signature);
        }
        DigestAlgorithm algorithm = this.algorithmManager.getDigestAlgorithmByOID(si.getDigestAlgorithm().getOID().getOID());
        BaseSignedContentPart contentPart = null;
        if (this.sda instanceof DetachedSignedData) {
            for (DetachedSignedData other : ((DetachedSignedData)this.sda).getOnSameContent()) {
                SignedContentPart signedContentPart = other.getSignedContentPart();
                if (signedContentPart == null || !algorithm.getOID().equals(signedContentPart.getDigestAlgorithm().getOID())) continue;
                contentPart = signedContentPart;
                break;
            }
        }
        if (contentPart == null) {
            contentPart = new BaseSignedContentPart(contentData, digest, algorithm);
            if (this.sda instanceof DetachedSignedData) {
                ((DetachedSignedData)this.sda).setSignedContentPart((SignedContentPart)contentPart);
            }
        }
        if (hashValue != null) {
            contentPart.setCalculatedDigest(hashValue);
        }
        if (this.sda != null && this.sda.getContents() != null && !this.sda.getContents().isEmpty() && this.sda.getContents().get(0) != null) {
            contentPart.setContentName(((Document)this.sda.getContents().get(0)).getName());
        }
        signature.setSignedContentParts(Collections.singletonList(contentPart));
    }

    private StreamProvider getSignedContent(CMSSignature signature) {
        if (this.signedContentData != null) {
            if (signature != null) {
                signature.setSignatureType(this.signatureType);
            }
            return this.signedContentData;
        }
        SignatureType type = null;
        this.signedContentData = null;
        ANY content = this.contentInfo.getContent();
        this.includedFiles = new ArrayList<Document>();
        this.result.setIncludedFilesToValidate(this.includedFiles);
        File linkedContent = this.contentInfo.getLinkedContent();
        List contentFromRequest = null;
        if (this.sda != null) {
            contentFromRequest = this.sda.getContents();
        }
        if (content instanceof OCTETSTRING && (contentFromRequest == null || contentFromRequest.isEmpty())) {
            OCTETSTRING os = (OCTETSTRING)content;
            String name = this.result.getName() + "_enveloped_content";
            OCTETSTRINGDocument contentDoc = new OCTETSTRINGDocument(os, name, name);
            this.signedContentData = contentDoc;
            this.includedFiles.add(contentDoc);
            type = SignatureType.ENVELOPED;
        } else if (contentFromRequest != null && !contentFromRequest.isEmpty()) {
            this.signedContentData = new ConcatenatedDocumentInputStreamProvider(contentFromRequest);
            for (Document c : contentFromRequest) {
                this.includedFiles.add(c);
            }
            type = SignatureType.DETACHED;
        } else if (linkedContent != null) {
            this.signedContentData = new FileStreamProvider(linkedContent);
            this.includedFiles.add((Document)new FileDocumentImpl(linkedContent, linkedContent.getName()));
            type = SignatureType.DETACHED;
        }
        if (this.signedContentData == null) {
            type = SignatureType.DETACHED;
        }
        if (signature != null) {
            signature.setSignatureType(type);
        }
        this.signatureType = type;
        return this.signedContentData;
    }

    private void addENAttributeCertificates(CMSSignature signature, List<ANY> values) {
        if (values == null || values.isEmpty()) {
            return;
        }
        for (ANY value : values) {
            SignerAttributeV2 sa;
            List certifiedAttributes;
            if (!(value instanceof SignerAttributeV2) || (certifiedAttributes = (sa = (SignerAttributeV2)value).getCertifiedAttributes()) == null) continue;
            for (CertifiedAttributesV2 ca : certifiedAttributes) {
                AttributeCertificate ac = ca.getAttributeCertificate();
                if (ac == null) continue;
                CAdESParser.addAttributeCertificate(signature, ac);
            }
        }
    }

    private static void addNewAttributeCertificates(CMSSignature sig, List<ANY> values) {
        if (values == null || values.isEmpty()) {
            return;
        }
        for (ANY value : values) {
            if (!(value instanceof SignerAttribute)) continue;
            SignerAttribute a = (SignerAttribute)value;
            for (AttributeCertificate ac : a.getCertifiedAttributes()) {
                CAdESParser.addAttributeCertificate(sig, ac);
            }
        }
    }

    private static void addAttributeCertificate(CMSSignature sig, AttributeCertificate value) {
        if (value == null) {
            return;
        }
        LinkedHashSet<org.bouncycastle.asn1.x509.AttributeCertificate> attributeCertificates = sig.getAttributeCertificates();
        if (attributeCertificates == null) {
            attributeCertificates = new LinkedHashSet<org.bouncycastle.asn1.x509.AttributeCertificate>();
        }
        attributeCertificates.add(org.bouncycastle.asn1.x509.AttributeCertificate.getInstance((Object)value.getEncoded()));
        sig.setAttributeCertificates(attributeCertificates);
    }

    private static Date getSigningTime(EncapsulatedContentInfo contentInfo, SignerInfo signerInfo) {
        Time time;
        if (ContentType.id_ct_TSTInfo.equals((Object)contentInfo.getContentType())) {
            TSTInfo tst = (TSTInfo)contentInfo.getContent();
            time = tst.getGenTime();
        } else {
            time = (Time)signerInfo.getSignedAttributeValue(SignedAttribute.signingTime);
        }
        return time == null ? null : time.getDate();
    }

    private class CAdESArchiveTimestampFactory
    implements TimestampFactory<CAdESArchiveTimestamp, BaseSignature> {
        private SignedAttribute signedAttribute;
        private ANY attributeValue;

        public CAdESArchiveTimestampFactory(SignedAttribute signedAttribute, ANY attributeValue) {
            this.signedAttribute = signedAttribute;
            this.attributeValue = attributeValue;
        }

        public CAdESArchiveTimestamp createNewTimestamp() {
            return new CAdESArchiveTimestamp(this.signedAttribute, this.attributeValue);
        }
    }
}

