/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cades;

import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.AlgorithmIdentifier;
import de.bos_bremen.ci.asn1.OBJECTIDENTIFIER;
import de.bos_bremen.ci.asn1.OCTETSTRING;
import de.bos_bremen.ci.asn1.cms.AtsHashIndex;
import de.bos_bremen.ci.asn1.cms.SignedAttribute;
import de.governikus.csl.cades.CMSSignature;
import de.governikus.csl.cades.ats.CheckAtsHashIndex;
import de.governikus.csl.uom.core.AlgorithmServiceFacade;
import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.uom.validate.commons.SignatureValidationDataAttachment;
import de.governikus.csl.uom.validate.commons.Timestamp;
import de.governikus.csl.utils.DigestUtil;
import de.governikus.csl.validate.svp.TimestampValidationResult;
import de.governikus.csl.validation.ValidationCriterion;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.tsp.ArchiveTimestamp;
import de.governikus.csl.validation.tsp.TimestampedObject;
import java.io.IOException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAdESArchiveTimestamp
extends TimestampedObject
implements ArchiveTimestamp {
    private static final Logger LOGGER = LoggerFactory.getLogger(CAdESArchiveTimestamp.class);
    private SignedAttribute attribute;
    private ANY attributeValue;
    private CMSSignature signature;

    public CAdESArchiveTimestamp(SignedAttribute attribute, ANY attributeValue) {
        this.attribute = attribute;
        this.attributeValue = attributeValue;
    }

    public boolean isProtectedBy(ArchiveTimestamp next) {
        if (!((Object)((Object)this)).getClass().isInstance(next)) {
            return false;
        }
        CAdESArchiveTimestamp other = (CAdESArchiveTimestamp)((Object)((Object)((Object)this)).getClass().cast(next));
        List atsHashIndizes = other.getAtsHashIndizes();
        if (atsHashIndizes.isEmpty()) {
            return false;
        }
        AtsHashIndex atsHashIndex = (AtsHashIndex)atsHashIndizes.get(0);
        OBJECTIDENTIFIER hashAlgOID = atsHashIndex.getHashAlgorithm().getOID();
        DigestAlgorithm digestAlgorithm = new AlgorithmServiceFacade().getDigestAlgorithmByOID(hashAlgOID.getOID());
        List unsignedAttributesHashIndex = atsHashIndex.getUnsignedAttributesHashIndex();
        int version = atsHashIndex.getVersion();
        byte[] digest = null;
        if (version == 1 || version == 2) {
            digest = DigestUtil.createHash((byte[])this.attribute.getEncoded(), (DigestAlgorithm)digestAlgorithm);
        } else if (version == 3) {
            digest = DigestUtil.createHashQuietly((DigestAlgorithm)digestAlgorithm, (byte[][])new byte[][]{this.attribute.getObjectID().getEncoded(), this.attributeValue.getEncoded()});
        } else {
            return false;
        }
        return this.isByteArrayInOctetList(digest, unsignedAttributesHashIndex);
    }

    private boolean isByteArrayInOctetList(byte[] toFind, List<OCTETSTRING> octetList) {
        for (OCTETSTRING os : octetList) {
            byte[] octets = os.getOctets();
            if (!Arrays.areEqual((byte[])toFind, (byte[])octets)) continue;
            return true;
        }
        return false;
    }

    public boolean isSignatureTimestampProtected(Timestamp signatureTimestamp, Signature signature) {
        return true;
    }

    public List<ValidationCriterion<? super Timestamp, ? super TimestampValidationResult, ? super SignatureValidationContext>> getCustomPlugins() {
        ArrayList<ValidationCriterion<? super Timestamp, ? super TimestampValidationResult, ? super SignatureValidationContext>> res = new ArrayList<ValidationCriterion<? super Timestamp, ? super TimestampValidationResult, ? super SignatureValidationContext>>();
        res.add((ValidationCriterion<? super Timestamp, ? super TimestampValidationResult, ? super SignatureValidationContext>)new CheckAtsHashIndex());
        return res;
    }

    public CMSSignature getSignature() {
        return this.signature;
    }

    public void setSignature(CMSSignature signature) {
        this.signature = signature;
    }

    public boolean isOCSPValueProtected(SignatureValidationDataAttachment<OCSPResp> attachedOCSP) {
        byte[] encoded = null;
        try {
            encoded = ((OCSPResp)attachedOCSP.getValue()).getEncoded();
        }
        catch (IOException e) {
            LOGGER.info("Can't get encoded bytes from OCSP", (Throwable)e);
            return false;
        }
        return this.isInHashIndex(encoded, AtsHashIndex::getCrlsHashIndex);
    }

    private boolean isInHashIndex(byte[] encoded, Function<AtsHashIndex, List<OCTETSTRING>> f) {
        List atsHashIndizes = this.getAtsHashIndizes();
        if (atsHashIndizes == null) {
            return false;
        }
        for (AtsHashIndex index : atsHashIndizes) {
            AlgorithmIdentifier hashAlgorithm;
            byte[] hash;
            List<OCTETSTRING> crlsHashIndex = f.apply(index);
            if (crlsHashIndex == null || crlsHashIndex.isEmpty() || !this.areBytesInOctetStringList(hash = DigestUtil.createHash((byte[])encoded, (AlgorithmIdentifier)(hashAlgorithm = index.getHashAlgorithm())), crlsHashIndex)) continue;
            return true;
        }
        return false;
    }

    private boolean areBytesInOctetStringList(byte[] bytes, List<OCTETSTRING> list) {
        for (OCTETSTRING os : list) {
            byte[] octets = os.getOctets();
            if (!Arrays.areEqual((byte[])bytes, (byte[])octets)) continue;
            return true;
        }
        return false;
    }

    public boolean isCRLProtected(SignatureValidationDataAttachment<CRL> attachedCRL) {
        byte[] encoded = null;
        try {
            encoded = ((X509CRL)attachedCRL.getValue()).getEncoded();
        }
        catch (CRLException e) {
            LOGGER.info("Can't get encoded bytes from CRL", (Throwable)e);
            return false;
        }
        return this.isInHashIndex(encoded, AtsHashIndex::getCrlsHashIndex);
    }

    public boolean isCertProtected(SignatureValidationDataAttachment<X509Certificate> attachedCert) {
        byte[] encoded = null;
        try {
            encoded = ((X509Certificate)attachedCert.getValue()).getEncoded();
        }
        catch (CertificateEncodingException e) {
            LOGGER.info("Can't get encoded bytes from Cert", (Throwable)e);
            return false;
        }
        return this.isInHashIndex(encoded, AtsHashIndex::getCrlsHashIndex);
    }
}

