/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.utils.cert;

import java.util.Arrays;
import java.util.Optional;
import org.bouncycastle.asn1.x509.qualified.ETSIQCObjectIdentifiers;

public enum QcType {
    QcTypeESign(ETSIQCObjectIdentifiers.id_etsi_qct_esign.getId()),
    QcTypeESeal(ETSIQCObjectIdentifiers.id_etsi_qct_eseal.getId()),
    QcTypeWeb(ETSIQCObjectIdentifiers.id_etsi_qct_web.getId());

    private final String oid;

    private QcType(String oid) {
        this.oid = oid;
    }

    public String getOID() {
        return this.oid;
    }

    public static Optional<QcType> fromOID(String oid) {
        return Arrays.asList(QcType.values()).stream().filter(q -> q.getOID().equals(oid)).findAny();
    }
}

