/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.utils.cert;

import de.governikus.csl.utils.cert.QCStatement;
import de.governikus.csl.utils.cert.QcType;
import de.governikus.csl.utils.cert.QcTypes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class QCStatements {
    public static final String OID_QC_COMPLIANCE = org.bouncycastle.asn1.x509.qualified.QCStatement.id_etsi_qcs_QcCompliance.getId();
    public static final String OID_QC_SSCD = org.bouncycastle.asn1.x509.qualified.QCStatement.id_etsi_qcs_QcSSCD.getId();
    public static final String OID_QC_TYPE = org.bouncycastle.asn1.x509.qualified.QCStatement.id_etsi_qcs_QcType.getId();
    private final List<QCStatement> statements = new ArrayList<QCStatement>();

    public static QCStatements getInstance(QCStatement ... qcStatements) {
        return new QCStatements(qcStatements);
    }

    private QCStatements(QCStatement ... qcStatements) {
        Stream.of(qcStatements).filter(Objects::nonNull).forEach(this.statements::add);
    }

    public boolean hasQcCompliance() {
        return this.statements.stream().anyMatch(s -> s.getOid().equals(OID_QC_COMPLIANCE));
    }

    public boolean hasQcSSCD() {
        return this.statements.stream().anyMatch(s -> s.getOid().equals(OID_QC_SSCD));
    }

    public boolean hasQcType() {
        return this.statements.stream().anyMatch(s -> s.getOid().equals(OID_QC_TYPE));
    }

    public List<QcType> getQcType() {
        return this.statements.stream().filter(s -> s.getOid().equals(OID_QC_TYPE)).findFirst().map(QcTypes.class::cast).map(QcTypes::getValues).orElse(Collections.emptyList());
    }
}

