/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.utils;

import de.governikus.csl.utils.GeneralException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IOUtil {
    private static final Logger LOG = LoggerFactory.getLogger(IOUtil.class);
    private static final String TMP_DIR = System.getProperty("java.io.tmpdir");

    private IOUtil() {
    }

    /*
     * Exception decompiling
     */
    public static byte[] compress(byte[] data) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static byte[] decompress(byte[] data) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static InputStream consume(InputStream is) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(IOUtil.read(is));
            return byteArrayInputStream;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                throw new GeneralException(e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] read(InputStream is) {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            int read;
            byte[] buf = new byte[16384];
            while ((read = is.read(buf)) >= 0) {
                os.write(buf, 0, read);
            }
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new GeneralException(e);
        }
    }

    public static File createTempFile(String name) {
        String uuid = UUID.randomUUID().toString().replace("-", "");
        File file = new File(TMP_DIR, name + uuid);
        LOG.trace("Create temp file {}", (Object)file.getAbsolutePath());
        IOUtil.deleteOnExit(file);
        return file;
    }

    public static File createTempDirectory(String name) {
        String uuid = UUID.randomUUID().toString().replace("-", "");
        File tempDir = IOUtil.createDirectory(TMP_DIR, name + uuid);
        LOG.trace("Create temp dir {}", (Object)tempDir.getAbsolutePath());
        IOUtil.deleteOnExit(tempDir);
        return tempDir;
    }

    public static File createDirectory(String path) {
        return IOUtil.createDirectory(new File(path));
    }

    public static File createDirectory(File parent, String name) {
        return IOUtil.createDirectory(new File(parent, name));
    }

    public static File createDirectory(String parent, String name) {
        return IOUtil.createDirectory(new File(parent, name));
    }

    public static void writeFile(String name, byte[] content) {
        IOUtil.writeFile(new File(name), content);
    }

    public static void writeFile(File parent, String name, byte[] content) {
        IOUtil.writeFile(new File(parent, name), content);
    }

    public static void writeFile(String parent, String name, byte[] content) {
        IOUtil.writeFile(new File(parent, name), content);
    }

    public static void writeFile(File file, byte[] content) {
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(content);
        }
        catch (IOException e) {
            throw new GeneralException(e);
        }
    }

    public static byte[] readFile(String name) {
        return IOUtil.readFile(new File(name));
    }

    public static byte[] readFile(File parent, String name) {
        return IOUtil.readFile(new File(parent, name));
    }

    public static byte[] readFile(String parent, String name) {
        return IOUtil.readFile(new File(parent, name));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readFile(File file) {
        try (FileInputStream is = new FileInputStream(file);){
            byte[] byArray = IOUtil.read(is);
            return byArray;
        }
        catch (IOException e) {
            throw new GeneralException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readResource(String name, ClassLoader classLoader) {
        try (InputStream is = classLoader.getResourceAsStream(name);){
            byte[] byArray = IOUtil.read(is);
            return byArray;
        }
        catch (IOException e) {
            throw new GeneralException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readResource(String name) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try (InputStream is = classLoader.getResourceAsStream(name);){
            byte[] byArray = IOUtil.read(is);
            return byArray;
        }
        catch (IOException e) {
            throw new GeneralException(e);
        }
    }

    public static boolean delete(File file) {
        if (file.isDirectory() && !IOUtil.clear(file)) {
            return false;
        }
        return file.delete();
    }

    public static boolean clear(File file) {
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                if (IOUtil.delete(f)) continue;
                return false;
            }
            return file.listFiles().length == 0;
        }
        return true;
    }

    public static void deleteOnExit(File file) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> IOUtil.shutdown(file)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] write(Consumer<OutputStream> consumer) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            consumer.accept(baos);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new GeneralException(e);
        }
    }

    public static List<Integer> searchOccurrences(byte[] pattern, byte[] data) {
        if (data == null || data.length == 0 || pattern == null || pattern.length == 0) {
            return new ArrayList<Integer>();
        }
        ArrayList<Integer> res = new ArrayList<Integer>();
        int INVALID_POTENTIAL_INDEX_WITHIN_DATA = -1;
        int potentialIndexWithinData = -1;
        int patternIndex = 0;
        for (int dataIndex = 0; dataIndex < data.length && data.length - dataIndex >= pattern.length - patternIndex; ++dataIndex) {
            if (data[dataIndex] == pattern[patternIndex]) {
                ++patternIndex;
                if (potentialIndexWithinData == -1) {
                    potentialIndexWithinData = dataIndex;
                }
            } else {
                patternIndex = 0;
                potentialIndexWithinData = -1;
            }
            if (patternIndex != pattern.length) continue;
            if (potentialIndexWithinData != -1) {
                res.add(potentialIndexWithinData);
            }
            potentialIndexWithinData = -1;
            patternIndex = 0;
        }
        return res;
    }

    public static Zipper zip() {
        return new Zipper();
    }

    private static void shutdown(File file) {
        if (IOUtil.delete(file)) {
            LOG.trace("Delete {}", (Object)file.getAbsolutePath());
        } else {
            LOG.warn("Could not delete {}", (Object)file.getAbsolutePath());
        }
    }

    private static File createDirectory(File dir) {
        if (!dir.exists()) {
            dir.mkdir();
        }
        return dir;
    }

    public static class Zipper {
        private ByteArrayOutputStream os = new ByteArrayOutputStream();
        private ZipOutputStream zos = new ZipOutputStream(this.os);

        private Zipper() {
        }

        public Zipper add(String name, byte[] content) {
            try {
                ZipEntry entry = new ZipEntry(name);
                this.zos.putNextEntry(entry);
                this.zos.write(content);
                this.zos.closeEntry();
                return this;
            }
            catch (IOException e) {
                throw new GeneralException(e);
            }
        }

        public byte[] finish() {
            try {
                this.zos.finish();
                byte[] byArray = this.os.toByteArray();
                return byArray;
            }
            catch (IOException e) {
                throw new GeneralException(e);
            }
            finally {
                try {
                    this.zos.close();
                }
                catch (IOException e) {
                    throw new GeneralException(e);
                }
            }
        }
    }
}

