/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.utils;

import de.governikus.csl.utils.CryptoProviderUtil;
import de.governikus.csl.utils.GeneralException;
import de.governikus.csl.utils.X509TrustManagerWrapper;
import de.governikus.csl.utils.cert.QCStatement;
import de.governikus.csl.utils.cert.QCStatements;
import de.governikus.csl.utils.cert.QcType;
import de.governikus.csl.utils.cert.QcTypes;
import de.governikus.csl.utils.cert.Usage;
import de.governikus.utils.secutils.SecurityUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.asn1.x509.qualified.ETSIQCObjectIdentifiers;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMException;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class CryptoUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CryptoUtil.class);
    private static final Logger LOG = LoggerFactory.getLogger(CryptoUtil.class);
    public static final String KEY_STORE_TYPE_JKS = "JKS";
    public static final String KEY_STORE_TYPE_PKCS12 = "PKCS12";
    public static final String XML_NS_DSIG = "http://www.w3.org/2000/09/xmldsig#";
    public static final String XML_ELEM_X509C = "X509Certificate";
    public static final String UNKNOWN_SIGNER = "unknown";
    private static final String MSG_XML_DOC_CREATION_ERROR = "Can't create document from given stream";
    private static final String MSG_NO_OR_MULTIPLE_SIGNER = "Found none or more than one signing certificate.";
    private static final String MSG_CERT_PARSE_ERROR = "Could not parse signer certificate";
    private static final JcaPEMKeyConverter KEY_CONVERTER = new JcaPEMKeyConverter();
    private static CertificateFactory cf;

    private CryptoUtil() {
    }

    public static void registerBouncyCastle() {
        Provider provider = Security.getProvider("BC");
        if (provider == null) {
            provider = new BouncyCastleProvider();
            Security.addProvider(provider);
            LOG.trace("Add {}", (Object)provider.getInfo());
        }
        LOG.info("Registered JCE provider: {}", (Object)provider.getInfo());
    }

    public static SSLContext sslContext(KeyStore keyStore, String keyStorePassword, KeyStore trustStore, boolean trustSelfsigned, X509Certificate ... trustedCertificates) throws GeneralSecurityException, IOException {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        KeyManager[] keyManagers = null;
        if (keyStore != null) {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, keyStorePassword.toCharArray());
            keyManagers = kmf.getKeyManagers();
        }
        X509TrustManagerWrapper trustManager = CryptoUtil.trustManager(trustStore, trustSelfsigned, trustedCertificates);
        sslContext.init(keyManagers, new TrustManager[]{trustManager}, new SecureRandom());
        return sslContext;
    }

    public static X509TrustManagerWrapper trustManager(KeyStore trustStore, boolean trustSelfsigned, X509Certificate ... trustedCertificates) throws GeneralSecurityException, IOException {
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        KeyStore store = CryptoUtil.loadJsseStore();
        CryptoUtil.addCerts(store, trustStore);
        CryptoUtil.addCerts(store, trustedCertificates);
        tmf.init(store);
        X509TrustManager trustManager = (X509TrustManager)tmf.getTrustManagers()[0];
        return new X509TrustManagerWrapper(trustManager, trustSelfsigned);
    }

    private static void addCerts(KeyStore store, KeyStore trustStore) throws KeyStoreException {
        if (trustStore == null) {
            return;
        }
        Enumeration<String> aliases = trustStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!trustStore.isCertificateEntry(alias)) continue;
            store.setCertificateEntry(alias, trustStore.getCertificate(alias));
        }
    }

    private static void addCerts(KeyStore trustStore, X509Certificate ... trustedCertificates) throws KeyStoreException {
        if (trustedCertificates.length > 0) {
            for (X509Certificate trustedCertificate : trustedCertificates) {
                trustStore.setCertificateEntry(CryptoUtil.getCommonName(trustedCertificate.getSubjectX500Principal()), trustedCertificate);
            }
        }
    }

    public static KeyStore loadJsseStore() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, FileNotFoundException {
        String javaHome = System.getProperty("java.home");
        KeyStore store = KeyStore.getInstance(KEY_STORE_TYPE_JKS);
        try (FileInputStream is = new FileInputStream(javaHome + "/lib/security/cacerts");){
            store.load(is, null);
        }
        return store;
    }

    public static BasicOCSPResp getBasicOCSPResp(OCSPResp ocspResp) {
        try {
            return (BasicOCSPResp)ocspResp.getResponseObject();
        }
        catch (OCSPException e) {
            throw new GeneralException(e);
        }
    }

    public static X509Certificate getResponseSigningCertificate(OCSPResp ocspResp) {
        BasicOCSPResp basicOCSPResp = CryptoUtil.getBasicOCSPResp(ocspResp);
        X509CertificateHolder certificateHolder = basicOCSPResp.getCerts()[0];
        return CryptoUtil.toX509Certificate(certificateHolder);
    }

    public static List<X509Certificate> getAllCertificates(OCSPResp ocspResp) {
        BasicOCSPResp basicOCSPResp = CryptoUtil.getBasicOCSPResp(ocspResp);
        X509CertificateHolder[] certs = basicOCSPResp.getCerts();
        return Stream.of(certs).map(CryptoUtil::toX509Certificate).collect(Collectors.toList());
    }

    public static Date getArchiveCutoff(OCSPResp ocspResp) {
        BasicOCSPResp basicOCSPResp = CryptoUtil.getBasicOCSPResp(ocspResp);
        SingleResp resp = basicOCSPResp.getResponses()[0];
        Extension extension = resp.getExtension(OCSPObjectIdentifiers.id_pkix_ocsp_archive_cutoff);
        if (extension == null) {
            return null;
        }
        ASN1GeneralizedTime time = (ASN1GeneralizedTime)extension.getParsedValue();
        try {
            return time.getDate();
        }
        catch (ParseException e) {
            throw new GeneralException(e);
        }
    }

    public static X509Certificate toX509Certificate(X509CertificateHolder certificateHolder) {
        try {
            return new JcaX509CertificateConverter().getCertificate(certificateHolder);
        }
        catch (CertificateException e) {
            throw new GeneralException(e);
        }
    }

    public static boolean isResponseSignatureValid(OCSPResp ocspResp) {
        try {
            X509Certificate responseSigningCertificate = CryptoUtil.getResponseSigningCertificate(ocspResp);
            ContentVerifierProvider provider = new JcaContentVerifierProviderBuilder().setProvider("BC").build(responseSigningCertificate);
            return CryptoUtil.getBasicOCSPResp(ocspResp).isSignatureValid(provider);
        }
        catch (OCSPException | OperatorCreationException e) {
            throw new GeneralException(e);
        }
    }

    public static byte[] getEncoded(X509Certificate certificate) {
        try {
            return certificate.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new GeneralException(e);
        }
    }

    public static byte[] getEncoded(PrivateKey key) {
        return key.getEncoded();
    }

    public static byte[] getEncoded(ASN1Object o) {
        try {
            return o.getEncoded();
        }
        catch (IOException e) {
            throw new GeneralException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static X509Certificate readEncodedCert(byte[] encodedCert) {
        try (ByteArrayInputStream is = new ByteArrayInputStream(encodedCert);){
            X509Certificate x509Certificate = (X509Certificate)CryptoUtil.certificateFactory().generateCertificate(is);
            return x509Certificate;
        }
        catch (IOException | GeneralSecurityException e) {
            throw new GeneralException(e);
        }
    }

    public static PrivateKey readEncodedPrivateKey(byte[] encodedKey) {
        try {
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance((Object)encodedKey);
            return KEY_CONVERTER.getPrivateKey(privateKeyInfo);
        }
        catch (PEMException e) {
            throw new GeneralException(e);
        }
    }

    public static synchronized CertificateFactory certificateFactory() {
        if (cf == null) {
            try {
                cf = CertificateFactory.getInstance("X.509");
            }
            catch (CertificateException e) {
                throw new GeneralException(e);
            }
        }
        return cf;
    }

    public static List<Usage> getKeyUsages(X509Certificate certificate) {
        ArrayList<Usage> usages = new ArrayList<Usage>();
        boolean[] usage = certificate.getKeyUsage();
        if (usage[0]) {
            usages.add(Usage.digitalSignature);
        }
        if (usage[1]) {
            usages.add(Usage.nonRepudiation);
        }
        if (usage[2]) {
            usages.add(Usage.keyEncipherment);
        }
        if (usage[3]) {
            usages.add(Usage.dataEncipherment);
        }
        if (usage[4]) {
            usages.add(Usage.keyAgreement);
        }
        if (usage[5]) {
            usages.add(Usage.keyCertSign);
        }
        if (usage[6]) {
            usages.add(Usage.cRLSign);
        }
        if (usage[7]) {
            usages.add(Usage.encipherOnly);
        }
        if (usage[8]) {
            usages.add(Usage.decipherOnly);
        }
        return usages;
    }

    public static QCStatements getQCStatements(X509Certificate certificate) {
        try {
            ASN1Sequence statements = CryptoUtil.parseQCStatements(certificate);
            return QCStatements.getInstance(CryptoUtil.getQcCompliance(statements), CryptoUtil.getQcSSCD(statements), CryptoUtil.getQcTypes(statements));
        }
        catch (Exception e) {
            throw new GeneralException(e);
        }
    }

    public static byte[] messageDigest(String algorithm, byte[] value) {
        try {
            return MessageDigest.getInstance(algorithm, "BC").digest(value);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new GeneralException(e);
        }
    }

    public static String hexString(byte[] value) {
        return CryptoUtil.hexString(value, false);
    }

    public static String hexString(byte[] value, boolean pretty) {
        StringBuilder sb = new StringBuilder();
        for (byte b : value) {
            String hexString = Integer.toHexString(Byte.toUnsignedInt(b));
            if (hexString.length() == 1) {
                hexString = "0" + hexString;
            }
            sb.append(hexString);
            if (!pretty) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String getRelativeDistinguishName(X500Principal x500Principal, ASN1ObjectIdentifier oid) {
        X500Name x500Name = new X500Name(x500Principal.getName());
        return CryptoUtil.getRelativeDistinguishName(x500Name, oid);
    }

    public static String getRelativeDistinguishName(X500Name x500Name, ASN1ObjectIdentifier oid) {
        RDN[] rdNs = x500Name.getRDNs(oid);
        if (rdNs.length == 0) {
            return null;
        }
        for (RDN rdN : rdNs) {
            AttributeTypeAndValue[] typesAndValues;
            for (AttributeTypeAndValue typeAndValue : typesAndValues = rdN.getTypesAndValues()) {
                if (!typeAndValue.getType().equals((ASN1Primitive)oid)) continue;
                return typeAndValue.getValue().toString();
            }
        }
        return null;
    }

    public static String getCommonName(X500Principal x500Principal) {
        X500Name x500Name = new X500Name(x500Principal.getName());
        return CryptoUtil.getRelativeDistinguishName(x500Name, X509ObjectIdentifiers.commonName);
    }

    public static String getCountryCode(X500Principal x500Principal) {
        X500Name x500Name = new X500Name(x500Principal.getName());
        return CryptoUtil.getRelativeDistinguishName(x500Name, X509ObjectIdentifiers.countryName);
    }

    public static KeyStore loadKeyStore(String fileOrResource, char[] password) {
        try {
            return CryptoUtil.loadJKSKeyStore(fileOrResource, password);
        }
        catch (Exception e) {
            return CryptoUtil.loadPKCS12KeyStore(fileOrResource, password);
        }
    }

    public static KeyStore newPKCS12KeyStore() {
        try {
            return CryptoUtil.loadStore(null, null, KEY_STORE_TYPE_PKCS12);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new GeneralException(e);
        }
    }

    public static KeyStore loadPKCS12KeyStore(String fileOrResource, char[] password) {
        if (fileOrResource.startsWith("classpath:")) {
            return CryptoUtil.loadPKCS12KeyStoreResource(fileOrResource.replace("classpath:", ""), password);
        }
        return CryptoUtil.loadPKCS12KeyStoreFile(fileOrResource, password);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static KeyStore loadPKCS12KeyStoreResource(String filename, char[] password, ClassLoader classLoader) {
        try (InputStream is = classLoader.getResourceAsStream(filename);){
            KeyStore keyStore = CryptoUtil.loadStore(password, is, KEY_STORE_TYPE_PKCS12);
            return keyStore;
        }
        catch (IOException | GeneralSecurityException e) {
            throw new GeneralException(e);
        }
    }

    public static KeyStore loadPKCS12KeyStoreResource(String filename, char[] password) {
        return CryptoUtil.loadPKCS12KeyStoreResource(filename, password, Thread.currentThread().getContextClassLoader());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static KeyStore loadPKCS12KeyStoreFile(String filename, char[] password) {
        try (FileInputStream is = new FileInputStream(filename);){
            KeyStore keyStore = CryptoUtil.loadStore(password, is, KEY_STORE_TYPE_PKCS12);
            return keyStore;
        }
        catch (IOException | GeneralSecurityException e) {
            throw new GeneralException(e);
        }
    }

    public static KeyStore newJKSKeyStore() {
        try {
            return CryptoUtil.loadStore(null, null, KEY_STORE_TYPE_JKS);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new GeneralException(e);
        }
    }

    public static KeyStore loadJKSKeyStore(String fileOrResource, char[] password) {
        if (fileOrResource.startsWith("classpath:")) {
            return CryptoUtil.loadJKSKeyStoreResource(fileOrResource.replace("classpath:", ""), password);
        }
        return CryptoUtil.loadJKSKeyStoreFile(fileOrResource, password);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static KeyStore loadJKSKeyStoreFile(String filename, char[] password) {
        try (FileInputStream is = new FileInputStream(filename);){
            KeyStore keyStore = CryptoUtil.loadStore(password, is, KEY_STORE_TYPE_JKS);
            return keyStore;
        }
        catch (IOException | GeneralSecurityException e) {
            throw new GeneralException(e);
        }
    }

    public static KeyStore loadJKSKeyStoreResource(String filename, char[] password) {
        return CryptoUtil.loadJKSKeyStoreResource(filename, password, Thread.currentThread().getContextClassLoader());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static KeyStore loadJKSKeyStoreResource(String filename, char[] password, ClassLoader classLoader) {
        try (InputStream is = classLoader.getResourceAsStream(filename);){
            KeyStore keyStore = CryptoUtil.loadStore(password, is, KEY_STORE_TYPE_JKS);
            return keyStore;
        }
        catch (IOException | GeneralSecurityException e) {
            throw new GeneralException(e);
        }
    }

    private static KeyStore loadStore(char[] password, InputStream is, String type) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, NoSuchProviderException {
        KeyStore store = null;
        store = type.equals(KEY_STORE_TYPE_PKCS12) ? KeyStore.getInstance(type, "BC") : KeyStore.getInstance(type);
        store.load(is, password);
        return store;
    }

    public static void storeKeyStore(KeyStore store, String filename, char[] password) throws GeneralSecurityException, IOException {
        try (FileOutputStream os = new FileOutputStream(filename);){
            store.store(os, password);
        }
    }

    public static byte[] storeKeystore(KeyStore store, char[] password) throws GeneralSecurityException, IOException {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            store.store(os, password);
            byte[] byArray = os.toByteArray();
            return byArray;
        }
    }

    public static boolean areEqual(SubjectKeyIdentifier s1, SubjectKeyIdentifier s2) {
        return Arrays.equals(CryptoUtil.getEncoded((ASN1Object)s1), CryptoUtil.getEncoded((ASN1Object)s2));
    }

    public static X500Name toX500Name(X500Principal x500Principal) {
        String commonName = CryptoUtil.getCommonName(x500Principal);
        String countryCode = CryptoUtil.getCountryCode(x500Principal);
        return CryptoUtil.toX500Name(commonName, countryCode);
    }

    public static X500Name toX500Name(String commonName, String countryCode) {
        if (commonName == null && countryCode == null) {
            return null;
        }
        X500NameBuilder x500NameBuilder = new X500NameBuilder();
        if (commonName != null) {
            x500NameBuilder.addRDN(X509ObjectIdentifiers.commonName, commonName);
        }
        if (countryCode != null) {
            x500NameBuilder.addRDN(X509ObjectIdentifiers.countryName, countryCode);
        }
        return x500NameBuilder.build();
    }

    public static KeyStore createPKCS12KeyStore(PrivateKey key, X509Certificate certificate, String alias, char[] pin) throws GeneralSecurityException, IOException {
        KeyStore store = KeyStore.getInstance(KEY_STORE_TYPE_PKCS12, "BC");
        store.load(null, null);
        store.setKeyEntry(alias, key, pin, new X509Certificate[]{certificate});
        return store;
    }

    public static KeyStore createJKSKeyStore(PrivateKey key, X509Certificate certificate, String alias, char[] pin) throws GeneralSecurityException, IOException {
        KeyStore store = KeyStore.getInstance(KEY_STORE_TYPE_JKS);
        store.load(null, null);
        store.setKeyEntry(alias, key, pin, new X509Certificate[]{certificate});
        return store;
    }

    public static KeyStore createJKSTrustStore(X509Certificate certificate, String alias) throws GeneralSecurityException, IOException {
        KeyStore store = KeyStore.getInstance(KEY_STORE_TYPE_JKS);
        store.load(null, null);
        store.setCertificateEntry(alias, certificate);
        return store;
    }

    public static KeyStore createPKCS12TrustStore(X509Certificate certificate, String alias) throws GeneralSecurityException, IOException {
        KeyStore store = KeyStore.getInstance(KEY_STORE_TYPE_PKCS12, "BC");
        store.load(null, null);
        store.setCertificateEntry(alias, certificate);
        return store;
    }

    public static String getX500NameHash(X500Principal principal) {
        byte[] encoded = principal.getEncoded();
        byte[] digest = CryptoUtil.messageDigest("SHA-1", encoded);
        return CryptoUtil.hexString(digest);
    }

    public static String getOCSPExtensionURL(X509Certificate certificate) throws GeneralException {
        return CryptoUtil.getFromAuthorityAccess(certificate, AccessDescription.id_ad_ocsp);
    }

    public static String getOCSPExtensionCaIssuers(X509Certificate certificate) throws GeneralException {
        return CryptoUtil.getFromAuthorityAccess(certificate, AccessDescription.id_ad_caIssuers);
    }

    public static Document createDocument(String xml) throws IOException {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));){
            Document document = CryptoUtil.createDocument(bais);
            return document;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Document createDocument(InputStream stream) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            SecurityUtils.protectFactoryAgainstXXE((DocumentBuilderFactory)dbf);
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            try (InputStream is = stream;){
                Document document = db.parse(is);
                return document;
            }
        }
        catch (Exception e) {
            log.error(MSG_XML_DOC_CREATION_ERROR, (Throwable)e);
            return null;
        }
    }

    public static String getSignerCommonName(Document doc) {
        NodeList nl = doc.getElementsByTagNameNS(XML_NS_DSIG, XML_ELEM_X509C);
        if (nl == null || nl.getLength() != 1) {
            log.debug(MSG_NO_OR_MULTIPLE_SIGNER);
            return UNKNOWN_SIGNER;
        }
        Node certNode = nl.item(0);
        String certB64 = certNode.getTextContent().trim();
        String certB64NoWhiteSpaces = StringUtils.deleteWhitespace((String)certB64);
        String certB64Unescaped = StringEscapeUtils.unescapeHtml4((String)certB64NoWhiteSpaces);
        try {
            byte[] certDecoded = Base64.getDecoder().decode(certB64Unescaped);
            X509Certificate cert = CryptoProviderUtil.loadCert((byte[])certDecoded);
            X500Principal subjectX500Principal = cert.getSubjectX500Principal();
            return CryptoUtil.getCommonName(subjectX500Principal);
        }
        catch (IOException | NoSuchProviderException | CertificateException e) {
            log.error(MSG_CERT_PARSE_ERROR, (Throwable)e);
            return UNKNOWN_SIGNER;
        }
    }

    private static String getFromAuthorityAccess(X509Certificate certificate, ASN1ObjectIdentifier oid) {
        byte[] extensionValue = certificate.getExtensionValue(Extension.authorityInfoAccess.getId());
        if (extensionValue == null) {
            return null;
        }
        try {
            AccessDescription[] accessDescriptions;
            ASN1Primitive extension = JcaX509ExtensionUtils.parseExtensionValue((byte[])extensionValue);
            AuthorityInformationAccess authorityInformationAccess = AuthorityInformationAccess.getInstance((Object)extension);
            for (AccessDescription ad : accessDescriptions = authorityInformationAccess.getAccessDescriptions()) {
                if (!ad.getAccessMethod().equals((ASN1Primitive)oid)) continue;
                return ad.getAccessLocation().getName().toString();
            }
            return null;
        }
        catch (IOException e) {
            throw new GeneralException(e);
        }
    }

    private static QCStatement getQcCompliance(ASN1Sequence qcStatements) {
        if (qcStatements == null) {
            return null;
        }
        for (ASN1Encodable statement : qcStatements) {
            ASN1Sequence values = (ASN1Sequence)statement;
            if (!ETSIQCObjectIdentifiers.id_etsi_qcs_QcCompliance.equals(values.getObjectAt(0))) continue;
            return new QCStatement("QcCompliance", ETSIQCObjectIdentifiers.id_etsi_qcs_QcCompliance.getId());
        }
        return null;
    }

    private static QCStatement getQcSSCD(ASN1Sequence qcStatements) {
        if (qcStatements == null) {
            return null;
        }
        for (ASN1Encodable statement : qcStatements) {
            ASN1Sequence values = (ASN1Sequence)statement;
            if (!ETSIQCObjectIdentifiers.id_etsi_qcs_QcSSCD.equals(values.getObjectAt(0))) continue;
            return new QCStatement("QcSSCD", ETSIQCObjectIdentifiers.id_etsi_qcs_QcSSCD.getId());
        }
        return null;
    }

    private static ASN1Sequence parseQCStatements(X509Certificate certificate) throws IOException {
        byte[] extensionValue = certificate.getExtensionValue(Extension.qCStatements.getId());
        if (extensionValue == null) {
            return null;
        }
        ASN1Primitive value = JcaX509ExtensionUtils.parseExtensionValue((byte[])extensionValue);
        return ASN1Sequence.getInstance((Object)value);
    }

    private static QcTypes getQcTypes(ASN1Sequence qcStatements) {
        if (qcStatements == null) {
            return null;
        }
        ArrayList<QcType> result = new ArrayList<QcType>();
        for (ASN1Encodable statement : qcStatements) {
            ASN1Sequence values = (ASN1Sequence)statement;
            if (!ETSIQCObjectIdentifiers.id_etsi_qcs_QcType.equals(values.getObjectAt(0))) continue;
            ASN1Sequence types = (ASN1Sequence)values.getObjectAt(1);
            for (ASN1Encodable type : types) {
                if (ETSIQCObjectIdentifiers.id_etsi_qct_esign.equals(type)) {
                    result.add(QcType.QcTypeESign);
                    continue;
                }
                if (ETSIQCObjectIdentifiers.id_etsi_qct_eseal.equals(type)) {
                    result.add(QcType.QcTypeESeal);
                    continue;
                }
                if (!ETSIQCObjectIdentifiers.id_etsi_qct_web.equals(type)) continue;
                result.add(QcType.QcTypeWeb);
            }
        }
        if (result.isEmpty()) {
            return null;
        }
        return new QcTypes(result.toArray(new QcType[0]));
    }
}

