/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public final class CollectionUtil {
    private CollectionUtil() {
    }

    public static <T> List<List<T>> toEquallyDistributed(List<T> source, int numPieces) {
        if (source == null) {
            return null;
        }
        if (source.size() < numPieces) {
            numPieces = source.size();
        }
        int remainder = source.size() % numPieces;
        int size = source.size() / numPieces;
        int from = 0;
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        for (int to = size + (remainder-- > 0 ? 1 : 0); to <= source.size(); to += size + (remainder-- > 0 ? 1 : 0)) {
            result.add(source.subList(from, to));
            from = to;
        }
        return result;
    }

    public static <T> List<List<T>> toEquallySized(List<T> source, int size) {
        if (source == null) {
            return null;
        }
        if (source.size() < size) {
            return Arrays.asList(source);
        }
        int numPieces = source.size() / size;
        if (source.size() % size > 0) {
            ++numPieces;
        }
        return CollectionUtil.toEquallyDistributed(source, numPieces);
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return !CollectionUtil.isEmpty(collection);
    }
}

