/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.jeebackend.trace;

import de.governikus.csl.jeebackend.trace.TraceContextDecorator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class TraceContextTypedCallableDecorator<R, T extends Callable<R>>
extends TraceContextDecorator<T>
implements Callable<R> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TraceContextTypedCallableDecorator.class);
    private ExecutorService execService;

    public TraceContextTypedCallableDecorator(ExecutorService execService, T typedDelegate, boolean keepPrev) {
        super(typedDelegate, keepPrev);
        this.execService = execService;
    }

    public TraceContextTypedCallableDecorator(ExecutorService execService, T typedDelegate) {
        this(execService, typedDelegate, false);
    }

    @Override
    public R call() throws Exception {
        try {
            MDC.put((String)"traceId", (String)this.traceId);
            MDC.put((String)"spanId", (String)this.spanId);
            Object v = ((Callable)this.delegate).call();
            return (R)v;
        }
        finally {
            if (!this.keepPrevSpan) {
                MDC.remove((String)"traceId");
            }
            MDC.remove((String)"spanId");
        }
    }

    public Future<R> submit() {
        return this.execService.submit(this);
    }

    public void restorePreviousSpan() {
        if (this.prevSpanId == null) {
            log.debug("Could not restore previous spanId for {}", (Object)this.traceId);
        } else {
            MDC.put((String)"spanId", (String)this.prevSpanId);
        }
    }

    @Generated
    public ExecutorService getExecService() {
        return this.execService;
    }

    @Generated
    public void setExecService(ExecutorService execService) {
        this.execService = execService;
    }
}

