/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.jeebackend.trace;

import de.governikus.csl.jeebackend.trace.TraceContext;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceContextDecorator<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TraceContextDecorator.class);
    public static final String TRACE_KEY = "traceId";
    public static final String SPAN_KEY = "spanId";
    protected String traceId;
    protected String spanId;
    protected T delegate;
    protected boolean keepPrevSpan = false;
    protected String prevSpanId;

    public TraceContextDecorator(T delegate) {
        this(delegate, false);
    }

    public TraceContextDecorator(T delegate, boolean keepPrevSpan) {
        this.delegate = delegate;
        this.keepPrevSpan = keepPrevSpan;
        this.spanId = TraceContext.generateRandomSpanId();
        TraceContext restore = TraceContext.restore();
        if (restore != null) {
            this.traceId = restore.traceId;
            if (keepPrevSpan) {
                this.prevSpanId = restore.spanId;
            }
        }
        if (this.traceId == null) {
            restore = new TraceContext();
            this.traceId = restore.traceId;
            log.debug("Could not restore trace context, created new one with traceId: {}", (Object)this.traceId);
        }
    }

    @Generated
    public String getTraceId() {
        return this.traceId;
    }

    @Generated
    public String getSpanId() {
        return this.spanId;
    }

    @Generated
    public T getDelegate() {
        return this.delegate;
    }

    @Generated
    public boolean isKeepPrevSpan() {
        return this.keepPrevSpan;
    }

    @Generated
    public String getPrevSpanId() {
        return this.prevSpanId;
    }

    @Generated
    public void setKeepPrevSpan(boolean keepPrevSpan) {
        this.keepPrevSpan = keepPrevSpan;
    }
}

