/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.jeebackend.trace;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class TraceContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TraceContext.class);
    public static final String TRACE_ID = "traceId";
    public static final String SPAN_ID = "spanId";
    public static final String TRACEPARENT = "traceparent";
    public static final String TRACESTATE = "tracestate";
    public static final Pattern TRACEPARENT_PATTERN = Pattern.compile("[0-9a-fA-F]{2}-([0-9a-fA-F]{32})-([0-9a-fA-F]{16})-([0-9a-fA-F]{2,})");
    public String traceparent;
    public final String tracestate;
    public final String traceId;
    public final String spanId;

    public TraceContext() {
        this(TraceContext.generateNewTraceparent(), null);
    }

    public TraceContext(String traceparent, String tracestate) {
        this.traceparent = traceparent;
        this.tracestate = tracestate;
        Matcher matcher = TRACEPARENT_PATTERN.matcher(traceparent);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("traceparent not conforming");
        }
        this.traceId = matcher.group(1);
        this.spanId = matcher.group(2);
    }

    public static TraceContext buildFromSingleValueMap(Map<String, String> headers) {
        return TraceContext.build(headers.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> Collections.singletonList(e.getValue()))));
    }

    public static TraceContext buildFromMultiValuedMap(Map<String, List<String>> headers) {
        return TraceContext.build(headers);
    }

    public static TraceContext build(Map<String, List<String>> headers) {
        String parent = TraceContext.getHeaderValue(headers, TRACEPARENT);
        if (parent == null) {
            log.trace("Header traceparent not found, generate new traceparent");
            return new TraceContext();
        }
        log.trace("Header traceparent found {}", (Object)parent);
        try {
            String state = TraceContext.getHeaderValue(headers, TRACESTATE);
            return new TraceContext(parent, state);
        }
        catch (IllegalArgumentException e) {
            log.trace(e.getMessage(), (Throwable)e);
            return new TraceContext();
        }
    }

    private static String getHeaderValue(Map<String, List<String>> headers, String headerName) {
        return headers.entrySet().stream().filter(e -> headerName.equalsIgnoreCase((String)e.getKey())).map(e -> (List)e.getValue()).filter(e -> e != null).flatMap(Collection::stream).findFirst().orElse(null);
    }

    public static String generateNewTraceparent() {
        return TraceContext.generateTraceparent(TraceContext.generateRandomTraceId(), TraceContext.generateRandomSpanId());
    }

    public static String generateTraceparent(String traceId, String spanId) {
        return "00-" + traceId + '-' + spanId + "-00";
    }

    private static String generateRandomTraceId() {
        return TraceContext.generateRandomHexStringNotAllNull(128);
    }

    public static String generateRandomSpanId() {
        return TraceContext.generateRandomHexStringNotAllNull(64);
    }

    private static String generateRandomHexStringNotAllNull(int bitLength) {
        byte[] bytes = new byte[bitLength / 8];
        do {
            new SecureRandom().nextBytes(bytes);
        } while (BigInteger.ZERO.equals(new BigInteger(1, bytes)));
        return Hex.encodeHexString((byte[])bytes);
    }

    public void store() {
        log.trace("Store  trace context");
        MDC.put((String)TRACE_ID, (String)this.traceId);
        MDC.put((String)SPAN_ID, (String)this.spanId);
        if (this.traceparent == null) {
            this.traceparent = TraceContext.generateTraceparent(this.traceId, this.spanId);
        }
        MDC.put((String)TRACEPARENT, (String)this.traceparent);
        if (this.tracestate != null) {
            MDC.put((String)TRACESTATE, (String)this.tracestate);
        }
        log.trace("Stored  trace context");
    }

    public static void remove() {
        log.trace("Remove trace context");
        MDC.remove((String)TRACE_ID);
        MDC.remove((String)SPAN_ID);
        MDC.remove((String)TRACEPARENT);
        MDC.remove((String)TRACESTATE);
        log.trace("Removed trace context");
    }

    public static TraceContext restore() {
        log.trace("Restore  trace context");
        return new TraceContext(MDC.get((String)TRACEPARENT), MDC.get((String)TRACESTATE), MDC.get((String)TRACE_ID), MDC.get((String)SPAN_ID));
    }

    public void propagate(Map<String, List<Object>> multivaluedMap) {
        if (this.traceparent == null) {
            log.trace("No trace context found, no info propagated");
            return;
        }
        multivaluedMap.put(TRACEPARENT, Collections.singletonList(this.traceparent));
        if (this.tracestate != null) {
            multivaluedMap.put(TRACESTATE, Collections.singletonList(this.tracestate));
        }
        log.trace("Trace context found, existing info propagated");
    }

    public void propagateToStringMap(Map<String, String> multivaluedMap) {
        if (this.traceparent == null) {
            log.trace("No trace context found, no info propagated");
            return;
        }
        multivaluedMap.put(TRACEPARENT, this.traceparent);
        if (this.tracestate != null) {
            multivaluedMap.put(TRACESTATE, this.tracestate);
        }
        log.trace("Trace context found, existing info propagated");
    }

    @Generated
    public String getTraceparent() {
        return this.traceparent;
    }

    @Generated
    public String getTracestate() {
        return this.tracestate;
    }

    @Generated
    public String getTraceId() {
        return this.traceId;
    }

    @Generated
    public String getSpanId() {
        return this.spanId;
    }

    @Generated
    public TraceContext(String traceparent, String tracestate, String traceId, String spanId) {
        this.traceparent = traceparent;
        this.tracestate = tracestate;
        this.traceId = traceId;
        this.spanId = spanId;
    }

    @Generated
    protected TraceContext(String tracestate, String traceId, String spanId) {
        this.tracestate = tracestate;
        this.traceId = traceId;
        this.spanId = spanId;
    }
}

