/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509.ext;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.OBJECTIDENTIFIER;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.ext.AbstractExtension;
import java.io.IOException;
import java.util.List;
import java.util.ResourceBundle;

public class ValidityModelExtension
extends AbstractExtension {
    OBJECTIDENTIFIER statementId;
    ANY validityModel;

    public ValidityModelExtension(Run _run) throws ParseException {
        super(_run);
    }

    @Override
    public void internalLoad(Run _run) throws ParseException {
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        _run.readLength();
        int end = this.getEnd();
        this.statementId = new OBJECTIDENTIFIER(_run);
        if (_run.pos() < end) {
            this.validityModel = new ANY(_run, false);
        }
    }

    public OBJECTIDENTIFIER getStatementId() {
        return this.statementId;
    }

    public ANY getValidityModel() {
        return this.validityModel;
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        if (this.validityModel != null) {
            w.indent();
            w.newLine();
            w.write(this.validityModel.toString());
            w.outdent();
        }
        w.newLine();
        w.write(125);
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle res, boolean _short) {
        List<Flattable.Pair> result = super.flatten(res, _short);
        String value = this.statementId.getOID();
        try {
            value = res.getString(value);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (this.validityModel == null) {
            result.add(new Flattable.Pair(null, value));
        } else {
            result.add(new Flattable.Pair(value, this.validityModel.toString()));
        }
        return result;
    }
}

