/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509.ext;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.CertPolicyId;
import de.bos_bremen.ci.asn1.x509.ext.AbstractExtension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;

public class PolicyMappingsExtension
extends AbstractExtension {
    List<IssuerSubjectPair> policyMappings;

    public PolicyMappingsExtension(Run _run) throws ParseException {
        super(_run);
    }

    @Override
    public void internalLoad(Run _run) throws ParseException {
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        this.policyMappings = new ArrayList<IssuerSubjectPair>();
        _run.readLength();
        int end = this.getEnd();
        while (_run.pos() < end) {
            tag = _run.get();
            if (tag == 48) {
                _run.next();
                _run.readLength();
            }
            IssuerSubjectPair pair = new IssuerSubjectPair();
            pair.issuerDomainPolicy = new CertPolicyId(_run);
            pair.subjectDomainPolicy = new CertPolicyId(_run);
            this.policyMappings.add(pair);
        }
    }

    public List<IssuerSubjectPair> getPolicyMappings() {
        return this.policyMappings;
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        if (!this.policyMappings.isEmpty()) {
            w.indent();
            w.newLine();
            Iterator<IssuerSubjectPair> iter = this.policyMappings.iterator();
            while (iter.hasNext()) {
                IssuerSubjectPair pair = iter.next();
                w.write(pair.issuerDomainPolicy.toString());
                w.write(pair.subjectDomainPolicy.toString());
                if (!iter.hasNext()) continue;
                w.newLine();
            }
            w.outdent();
        }
        w.newLine();
        w.write(125);
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle res, boolean _short) {
        List<Flattable.Pair> result = super.flatten(res, _short);
        for (IssuerSubjectPair pair : this.policyMappings) {
            result.add(new Flattable.Pair(res.getString("issuerDomainPolicy"), pair.issuerDomainPolicy.getOID()));
            result.add(new Flattable.Pair(res.getString("issuerDomainPolicy"), pair.subjectDomainPolicy.getOID()));
        }
        return result;
    }

    public static class IssuerSubjectPair {
        public CertPolicyId issuerDomainPolicy;
        public CertPolicyId subjectDomainPolicy;
    }
}

