/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509.ext;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.INTEGER;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.ext.AbstractExtension;
import java.io.IOException;
import java.util.List;
import java.util.ResourceBundle;

public class PolicyConstraintsExtension
extends AbstractExtension {
    INTEGER requireExplicitPolicy;
    INTEGER inhibitPolicyMapping;

    public PolicyConstraintsExtension(Run _run) throws ParseException {
        super(_run);
    }

    @Override
    public void internalLoad(Run _run) throws ParseException {
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        _run.readLength();
        int end = this.getEnd();
        if (_run.pos() >= end) {
            return;
        }
        tag = _run.get();
        if ((tag & 0xF) == 0) {
            this.requireExplicitPolicy = new INTEGER(_run, true);
            if (_run.pos() >= end) {
                return;
            }
            tag = _run.get();
        }
        if ((tag & 0xF) == 1) {
            this.inhibitPolicyMapping = new INTEGER(_run, true);
        }
    }

    public int getRequireExplicitPolicy() {
        return this.requireExplicitPolicy == null ? -1 : this.requireExplicitPolicy.getValue().intValue();
    }

    public int getInhibitPolicyMapping() {
        return this.inhibitPolicyMapping == null ? -1 : this.inhibitPolicyMapping.getValue().intValue();
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        if (this.requireExplicitPolicy != null || this.inhibitPolicyMapping != null) {
            w.indent();
            w.newLine();
            if (this.requireExplicitPolicy != null) {
                w.write(this.requireExplicitPolicy.toString());
                w.newLine();
            }
            if (this.inhibitPolicyMapping != null) {
                w.write(this.inhibitPolicyMapping.toString());
            }
            w.outdent();
        }
        w.newLine();
        w.write(125);
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle res, boolean _short) {
        String value;
        List<Flattable.Pair> result = super.flatten(res, _short);
        if (this.requireExplicitPolicy != null) {
            value = res.getString("requireExplicitPolicy");
            value = this.requireExplicitPolicy.getValue().toString() + value.substring(1);
            result.add(new Flattable.Pair(null, value));
        }
        if (this.inhibitPolicyMapping != null) {
            value = res.getString("inhibitPolicyMapping");
            value = this.inhibitPolicyMapping.getValue().toString() + value.substring(1);
            result.add(new Flattable.Pair(null, value));
        }
        return result;
    }
}

