/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509.ext;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.GeneralSubtree;
import de.bos_bremen.ci.asn1.x509.GeneralSubtrees;
import de.bos_bremen.ci.asn1.x509.ext.AbstractExtension;
import java.io.IOException;
import java.util.List;
import java.util.ResourceBundle;

public class NameConstraintsExtension
extends AbstractExtension {
    GeneralSubtrees permittedSubtrees;
    GeneralSubtrees excludedSubtrees;

    public NameConstraintsExtension(Run _run) throws ParseException {
        super(_run);
    }

    @Override
    public void internalLoad(Run _run) throws ParseException {
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        _run.readLength();
        int end = this.getEnd();
        if (_run.pos() >= end) {
            return;
        }
        tag = _run.get();
        if (ASN1.Factory.isTagged(tag) && (tag & 0xF) == 0 || tag == 48) {
            this.permittedSubtrees = new GeneralSubtrees(_run);
            if (_run.pos() >= end) {
                return;
            }
            tag = _run.get();
        }
        if (ASN1.Factory.isTagged(tag) && (tag & 0xF) == 1 || tag == 48) {
            this.excludedSubtrees = new GeneralSubtrees(_run);
        }
    }

    public GeneralSubtrees getPermittedSubtrees() {
        return this.permittedSubtrees;
    }

    public GeneralSubtrees getExcludedSubtrees() {
        return this.excludedSubtrees;
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        if (this.permittedSubtrees != null || this.excludedSubtrees != null) {
            w.indent();
            w.newLine();
            if (this.permittedSubtrees != null) {
                w.write("permitted :");
                w.indent();
                w.newLine();
                this.permittedSubtrees.dump(w);
                w.outdent();
            }
            if (this.excludedSubtrees != null) {
                w.newLine();
                w.write("excluded :");
                w.indent();
                w.newLine();
                this.excludedSubtrees.dump(w);
                w.outdent();
            }
            w.outdent();
            w.newLine();
        }
        w.newLine();
        w.write(125);
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle res, boolean _short) {
        List<Flattable.Pair> result = super.flatten(res, _short);
        if (this.permittedSubtrees != null) {
            result.add(new Flattable.Pair(res.getString("nameconstraints.permitted"), ""));
            for (GeneralSubtree subtree : this.permittedSubtrees.getSubtrees()) {
                result.addAll(subtree.getBase().flatten(res, false));
            }
        }
        if (this.excludedSubtrees != null) {
            result.add(new Flattable.Pair(res.getString("nameconstraints.excluded"), ""));
            for (GeneralSubtree subtree : this.excludedSubtrees.getSubtrees()) {
                result.addAll(subtree.getBase().flatten(res, false));
            }
        }
        return result;
    }
}

