/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509.ext;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.KeyUsage;
import de.bos_bremen.ci.asn1.x509.ext.AbstractExtension;
import java.io.IOException;
import java.util.List;
import java.util.ResourceBundle;

public class KeyUsageExtension
extends AbstractExtension {
    private KeyUsage keyUsage;

    public KeyUsageExtension(Run _run) throws ParseException {
        super(_run);
    }

    @Override
    public void internalLoad(Run _run) throws ParseException {
        this.keyUsage = new KeyUsage(_run);
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        this.keyUsage.dump(w);
        w.outdent();
        w.newLine();
        w.write(125);
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle res, boolean _short) {
        List<Flattable.Pair> result = super.flatten(res, _short);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 9; ++i) {
            if (!this.keyUsage.is(i)) continue;
            if (sb.length() > 0) {
                sb.append(',');
                sb.append(' ');
            }
            sb.append(res.getString("ku." + i));
        }
        result.add(new Flattable.Pair(null, this.keyUsage.getShortKeyUsage()));
        result.add(new Flattable.Pair(null, sb.toString()));
        return result;
    }

    public KeyUsage getKeyUsage() {
        return this.keyUsage;
    }
}

