/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509.ext;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.KeyPurposeId;
import de.bos_bremen.ci.asn1.x509.ext.AbstractExtension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;

public class ExtendedKeyUsageExtension
extends AbstractExtension {
    List<KeyPurposeId> keyPurposeIDs;

    public ExtendedKeyUsageExtension(Run _run) throws ParseException {
        super(_run);
    }

    @Override
    public void internalLoad(Run _run) throws ParseException {
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        this.keyPurposeIDs = new ArrayList<KeyPurposeId>();
        _run.readLength();
        int end = this.getEnd();
        while (_run.pos() < end) {
            KeyPurposeId oid = new KeyPurposeId(_run);
            this.keyPurposeIDs.add(oid);
        }
    }

    public List<KeyPurposeId> getKeyPurposeIDs() {
        return this.keyPurposeIDs;
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        if (!this.keyPurposeIDs.isEmpty()) {
            w.indent();
            w.newLine();
            Iterator<KeyPurposeId> iter = this.keyPurposeIDs.iterator();
            while (iter.hasNext()) {
                KeyPurposeId oid = iter.next();
                w.write(oid.toString());
                if (!iter.hasNext()) continue;
                w.newLine();
            }
            w.outdent();
        }
        w.newLine();
        w.write(125);
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle res, boolean _short) {
        List<Flattable.Pair> result = super.flatten(res, _short);
        StringBuilder sb = new StringBuilder();
        Iterator<KeyPurposeId> iter = this.keyPurposeIDs.iterator();
        while (iter.hasNext()) {
            KeyPurposeId oid = iter.next();
            String value = oid.getOID();
            try {
                value = res.getString(value);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            sb.append(value);
            if (!iter.hasNext()) continue;
            sb.append(',');
            sb.append(' ');
        }
        result.add(new Flattable.Pair(null, sb.toString()));
        return result;
    }
}

