/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509.ext;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.PolicyInformation;
import de.bos_bremen.ci.asn1.x509.ext.AbstractExtension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;

public class CertificatePoliciesExtension
extends AbstractExtension {
    List<PolicyInformation> policyInformations;

    public CertificatePoliciesExtension(Run _run) throws ParseException {
        super(_run);
    }

    @Override
    public void internalLoad(Run _run) throws ParseException {
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int len = _run.readLength();
        boolean indef = len == -1;
        int end = indef ? -1 : _run.pos() + len;
        this.policyInformations = new ArrayList<PolicyInformation>();
        while (indef || _run.pos() < end) {
            byte b;
            PolicyInformation pi = new PolicyInformation(_run);
            this.policyInformations.add(pi);
            if (!indef || (b = _run.get()) != 0) continue;
            _run.next();
            _run.next();
            break;
        }
    }

    public List<PolicyInformation> getPolicyInformations() {
        return this.policyInformations;
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        if (!this.policyInformations.isEmpty()) {
            w.indent();
            w.newLine();
            Iterator<PolicyInformation> iter = this.policyInformations.iterator();
            while (iter.hasNext()) {
                PolicyInformation pi = iter.next();
                pi.dump(w);
                if (!iter.hasNext()) continue;
                w.newLine();
            }
            w.outdent();
        }
        w.newLine();
        w.write(125);
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle res, boolean _short) {
        List<Flattable.Pair> result = super.flatten(res, _short);
        for (PolicyInformation pi : this.policyInformations) {
            result.addAll(pi.flatten(res, false));
        }
        return result;
    }
}

