/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509.ext;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.AlgorithmIdentifier;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.OCTETSTRING;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.Certificate;
import de.bos_bremen.ci.asn1.x509.ext.AbstractExtension;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;

public class CertHashExtension
extends AbstractExtension {
    AlgorithmIdentifier hashAlgorithm;
    OCTETSTRING certificateHash;

    public CertHashExtension(Run _run) throws ParseException {
        super(_run);
    }

    @Override
    public void internalLoad(Run _run) throws ParseException {
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        _run.readLength();
        this.hashAlgorithm = new AlgorithmIdentifier(_run);
        this.certificateHash = new OCTETSTRING(_run);
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        this.hashAlgorithm.dump(w);
        w.newLine();
        this.certificateHash.dump(w);
        w.outdent();
        w.newLine();
        w.write(125);
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle res, boolean _short) {
        List<Flattable.Pair> result = super.flatten(res, _short);
        result.add(new Flattable.Pair(res.getString("hashAlgorithm"), this.hashAlgorithm.getAlgorithmName()));
        result.add(new Flattable.Pair(res.getString("certificateHash"), this.certificateHash.getValueAsHexedString()));
        return result;
    }

    public boolean isCertHashValid(Certificate certificate) {
        if (certificate == null || this.hashAlgorithm == null || this.certificateHash == null) {
            return false;
        }
        byte[] fingerprint = certificate.getFingerprint(this.hashAlgorithm.getAlgorithmName());
        return this.certificateHash == null || fingerprint == null ? false : Arrays.equals(this.certificateHash.getValueAsByteArray(), fingerprint);
    }
}

