/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509.ext;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.DistributionPoint;
import de.bos_bremen.ci.asn1.x509.ext.AbstractExtension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;

public class CRLDistributionPointsExtension
extends AbstractExtension {
    List<DistributionPoint> distributionPoints;

    public CRLDistributionPointsExtension(Run _run) throws ParseException {
        super(_run);
    }

    @Override
    public void internalLoad(Run _run) throws ParseException {
        if (_run.next() != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        _run.readLength();
        this.distributionPoints = new ArrayList<DistributionPoint>();
        while (_run.pos() < this.getEnd()) {
            DistributionPoint distributionPoint = new DistributionPoint(_run);
            this.distributionPoints.add(distributionPoint);
        }
    }

    public List<DistributionPoint> getDistributionPoints() {
        return this.distributionPoints;
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        if (!this.distributionPoints.isEmpty()) {
            w.indent();
            w.newLine();
            Iterator<DistributionPoint> iter = this.distributionPoints.iterator();
            while (iter.hasNext()) {
                DistributionPoint distributionPoint = iter.next();
                distributionPoint.dump(w);
                if (!iter.hasNext()) continue;
                w.newLine();
            }
            w.outdent();
        }
        w.newLine();
        w.write(125);
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle res, boolean _short) {
        List<Flattable.Pair> result = super.flatten(res, _short);
        for (DistributionPoint distributionPoint : this.distributionPoints) {
            result.addAll(distributionPoint.flatten(res, false));
        }
        return result;
    }
}

