/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509.ext;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.BOOLEAN;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.INTEGER;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.ext.AbstractExtension;
import java.io.IOException;
import java.util.List;
import java.util.ResourceBundle;

public class BasicConstraintsExtension
extends AbstractExtension {
    BOOLEAN ca;
    INTEGER pathLenConstraints;

    public BasicConstraintsExtension(Run _run) throws ParseException {
        super(_run);
    }

    @Override
    public void internalLoad(Run _run) throws ParseException {
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        _run.readLength();
        int end = this.getEnd();
        BOOLEAN bOOLEAN = this.ca = _run.pos() < end ? new BOOLEAN(_run) : BOOLEAN.FALSE;
        if (_run.pos() < end) {
            this.pathLenConstraints = new INTEGER(_run);
        }
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        w.write("ca : " + this.ca.getValue());
        if (this.pathLenConstraints != null) {
            w.newLine();
            w.write("path length : " + this.pathLenConstraints.toString());
        }
        w.outdent();
        w.newLine();
        w.write(125);
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle res, boolean _short) {
        List<Flattable.Pair> result = super.flatten(res, _short);
        if (BOOLEAN.TRUE.equals(this.ca)) {
            result.add(new Flattable.Pair(null, res.getString("basicConstraints.ca")));
        }
        if (this.pathLenConstraints != null) {
            result.add(new Flattable.Pair(res.getString("pathLenConstraints"), this.pathLenConstraints.getValue().toString()));
        }
        return result;
    }

    public boolean isCA() {
        return this.ca.getValue();
    }

    public int getPathLenConstraint() {
        if (this.pathLenConstraints == null || this.pathLenConstraints.getValue() == null) {
            return -1;
        }
        return this.pathLenConstraints.getValue().intValue();
    }
}

