/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509.ext;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.OCTETSTRING;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.CertificateSerialNumber;
import de.bos_bremen.ci.asn1.x509.GeneralNames;
import de.bos_bremen.ci.asn1.x509.ext.AbstractExtension;
import java.io.IOException;
import java.util.List;
import java.util.ResourceBundle;

public class AuthorityKeyIdentifierExtension
extends AbstractExtension {
    OCTETSTRING keyIdentifier;
    GeneralNames authorityCertIssuer;
    CertificateSerialNumber authorityCertSerialNumber;

    public AuthorityKeyIdentifierExtension(Run _run) throws ParseException {
        super(_run);
    }

    public GeneralNames getAuthorityCertIssuer() {
        return this.authorityCertIssuer;
    }

    public OCTETSTRING getKeyIdentifier() {
        return this.keyIdentifier;
    }

    public CertificateSerialNumber getAuthorityCertSerialNumber() {
        return this.authorityCertSerialNumber;
    }

    @Override
    public void internalLoad(Run _run) throws ParseException {
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        this.setLength(_run.readLength());
        if (_run.pos() >= this.getEnd()) {
            return;
        }
        tag = _run.get();
        if (ASN1.Factory.isTagged(tag) && (tag & 0xF) == 0) {
            this.keyIdentifier = new OCTETSTRING(_run, true);
            if (_run.pos() >= this.getEnd()) {
                return;
            }
            tag = _run.get();
        }
        if (ASN1.Factory.isTagged(tag) && (tag & 0xF) == 1) {
            this.authorityCertIssuer = new GeneralNames(_run, true);
            if (_run.pos() >= this.getEnd()) {
                return;
            }
            tag = _run.get();
        }
        if (ASN1.Factory.isTagged(tag) && (tag & 0xF) == 2) {
            this.authorityCertSerialNumber = new CertificateSerialNumber(_run, true);
        }
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        if (this.keyIdentifier != null) {
            w.newLine();
            w.write("keyIdentifier: " + this.keyIdentifier.getValueAsString());
        }
        if (this.authorityCertIssuer != null) {
            w.newLine();
            this.authorityCertIssuer.dump(w);
        }
        if (this.authorityCertSerialNumber != null) {
            w.newLine();
            w.write(this.authorityCertSerialNumber.toString());
        }
        w.outdent();
        w.newLine();
        w.write(125);
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle res, boolean _short) {
        List<Flattable.Pair> result = super.flatten(res, _short);
        if (this.keyIdentifier != null) {
            result.add(new Flattable.Pair(res.getString("keyIdentifier"), this.keyIdentifier.getValueAsString()));
        }
        if (this.authorityCertIssuer != null) {
            result.addAll(this.authorityCertIssuer.flatten(res, false));
        }
        if (this.authorityCertSerialNumber != null) {
            result.add(new Flattable.Pair(res.getString("authorityCertSerialNumber"), this.authorityCertSerialNumber.getValue().toString()));
        }
        return result;
    }
}

