/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509.ext;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.AccessDescription;
import de.bos_bremen.ci.asn1.x509.ext.AbstractExtension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;

public class AuthorityInfoAccessExtension
extends AbstractExtension {
    List<AccessDescription> accessDescriptions = new ArrayList<AccessDescription>();

    public AuthorityInfoAccessExtension(Run _run) throws ParseException {
        super(_run);
    }

    @Override
    public void internalLoad(Run _run) throws ParseException {
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        this.setLength(_run.readLength());
        while (_run.pos() < this.getEnd()) {
            AccessDescription ad = new AccessDescription(_run);
            this.accessDescriptions.add(ad);
        }
    }

    public int size() {
        return this.accessDescriptions.size();
    }

    public List<AccessDescription> getAccessDescriptions() {
        return this.accessDescriptions;
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        if (!this.accessDescriptions.isEmpty()) {
            w.indent();
            w.newLine();
            Iterator<AccessDescription> iter = this.accessDescriptions.iterator();
            while (iter.hasNext()) {
                AccessDescription ad = iter.next();
                ad.dump(w);
                if (!iter.hasNext()) continue;
                w.newLine();
            }
            w.outdent();
        }
        w.newLine();
        w.write(125);
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle res, boolean _short) {
        List<Flattable.Pair> result = super.flatten(res, _short);
        for (AccessDescription ad : this.accessDescriptions) {
            result.addAll(ad.flatten(res, false));
        }
        return result;
    }
}

