/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509.ext;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.Source;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.BOOLEAN;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.OBJECTIDENTIFIER;
import de.bos_bremen.ci.asn1.OCTETSTRING;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.Extension;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public abstract class AbstractExtension
extends ANY
implements Extension,
Flattable,
Dumpable {
    private final OBJECTIDENTIFIER oid;
    private BOOLEAN critical;
    private OCTETSTRING octets;
    private boolean processed;

    public AbstractExtension(Run _run) throws ParseException {
        super(_run, false);
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        this.oid = new OBJECTIDENTIFIER(_run);
        tag = _run.get();
        this.critical = tag == 1 ? new BOOLEAN(_run) : BOOLEAN.FALSE;
        this.octets = new OCTETSTRING(_run);
    }

    protected AbstractExtension(String _oid) throws ParseException {
        this.oid = new OBJECTIDENTIFIER(_oid);
        this.critical = BOOLEAN.FALSE;
        this.octets = null;
    }

    @Override
    public OBJECTIDENTIFIER getObjectID() {
        return this.oid;
    }

    @Override
    public String getOID() {
        return this.oid.getOID();
    }

    @Override
    public OCTETSTRING getOctets() {
        return this.octets;
    }

    @Override
    public boolean isCritical() {
        return this.critical.getValue();
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle res, boolean _short) {
        ArrayList<Flattable.Pair> result = new ArrayList<Flattable.Pair>();
        String qualifiedClassName = this.getClass().getName();
        String className = qualifiedClassName.substring(qualifiedClassName.lastIndexOf(46) + 1);
        result.add(new Flattable.Pair(res.getString("extension.label"), res.getString(className) + " (" + this.getOID() + ")"));
        result.add(new Flattable.Pair(res.getString("critical.label"), res.getString("critical." + (this.isCritical() ? "y" : "n"))));
        if (!this.processed) {
            Source source = this.getSource();
            result.add(new Flattable.Pair(null, this.getLength() + " Bytes"));
            result.add(new Flattable.Pair(null, source.asHexedString(this.getOffset(), this.getLength())));
        }
        return result;
    }

    protected abstract void internalLoad(Run var1) throws ParseException;

    @Override
    public void load() throws ParseException {
        if (this.processed || this.octets == null) {
            return;
        }
        Run _run = Run.create(this.getSource(), this.octets.getOffset() + 1);
        _run.readLength();
        this.internalLoad(_run);
        this.processed = true;
    }
}

