/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509.ec;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.BITSTRING;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.OCTETSTRING;
import de.bos_bremen.ci.asn1.ParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class ECurve
extends ANY
implements Dumpable,
Flattable {
    protected OCTETSTRING a;
    protected OCTETSTRING b;
    protected BITSTRING seed;

    public ECurve(Run run) throws ParseException {
        super(run, false);
        byte tag = run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + run.pos(), run.pos());
        }
        int end = run.readLength();
        this.setEnd(end += run.pos());
        this.a = new OCTETSTRING(run);
        this.b = new OCTETSTRING(run);
        if (run.pos() >= end) {
            return;
        }
        this.seed = new BITSTRING(run);
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        w.write("a: " + this.a.getValueAsString());
        w.newLine();
        w.write("b: " + this.b.getValueAsString());
        if (this.seed != null) {
            w.newLine();
            w.write("seed: " + this.seed.getValueAsString());
        }
        w.outdent();
        w.newLine();
        w.write(125);
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle res, boolean _short) {
        ArrayList<Flattable.Pair> result = new ArrayList<Flattable.Pair>();
        result.add(new Flattable.Pair(res.getString("general.publickey.ec.ecparameters.curve.parameters.a"), this.a.getValueAsString()));
        result.add(new Flattable.Pair(res.getString("general.publickey.ec.ecparameters.curve.parameters.b"), this.b.getValueAsString()));
        if (this.seed != null) {
            result.add(new Flattable.Pair(res.getString("general.publickey.ec.ecparameters.curve.parameters.seed"), this.seed.getValueAsString()));
        }
        return result;
    }
}

