/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509.ec;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.AbstractFlattableDumpablePublicKey;
import de.bos_bremen.ci.asn1.x509.SubjectPublicKeyInfo;
import de.bos_bremen.ci.asn1.x509.ec.ECPKParameters;
import de.bos_bremen.ci.asn1.x509.ec.ECPoint;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class ECPublicKey
extends AbstractFlattableDumpablePublicKey {
    private static final long serialVersionUID = 3634087305147778053L;
    ECPKParameters ecParameters;
    ECPoint w;

    public ECPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws ParseException {
        super(subjectPublicKeyInfo);
    }

    @Override
    protected void initialize() throws ParseException {
        ANY parameters = this.subjectPublicKeyInfo.algorithm.getParameters();
        if (!(parameters instanceof ECPKParameters)) {
            throw new ParseException("Expected ECPKParameters");
        }
        this.ecParameters = (ECPKParameters)((Object)parameters);
        Run run = Run.create(this.subjectPublicKeyInfo.subjectPublicKey.getSource(), this.subjectPublicKeyInfo.subjectPublicKey.getOffset());
        this.w = new ECPoint(run);
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle bundle, boolean onlyShortList) {
        ArrayList<Flattable.Pair> pairs = new ArrayList<Flattable.Pair>();
        pairs.addAll(this.ecParameters.flatten(bundle, onlyShortList));
        pairs.add(new Flattable.Pair(bundle.getString("general.publickey.ec.ecparameters.w"), this.w.getValueAsString()));
        return pairs;
    }

    @Override
    public void dump(DumpWriter writer) throws IOException {
        ANY.writeClassName(this, writer);
        writer.write(32);
        writer.write(123);
        writer.indent();
        writer.newLine();
        this.ecParameters.dump(writer);
        writer.newLine();
        writer.write("w: " + this.w.getValueAsString());
        writer.newLine();
        writer.outdent();
        writer.newLine();
        writer.write(125);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ECPublicKey)) {
            return false;
        }
        ECPublicKey other = (ECPublicKey)o;
        return other.w.equals(this.w) && other.ecParameters.equals(this.ecParameters);
    }

    @Override
    public int hashCode() {
        return this.w.hashCode() ^ this.ecParameters.hashCode();
    }

    @Override
    public String toString() {
        return "ECDSAPublicKey[ECParameters=" + this.ecParameters + ", W=" + this.w + "]";
    }
}

